/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.util.task;

import com.bwanms.gui.util.AbstractTreeModel;
import com.bwanms.util.task.Operation;
import com.bwanms.util.task.OperationLog;
import com.bwanms.util.task.OperationStatus;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.event.TreeModelEvent;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OperationTree
extends AbstractTreeModel {
    private static final Logger logger = Logger.getLogger((String)"com.bwanms.rb");
    private OperationTreeNode root;
    private Map<Long, OperationTreeNode> nodes = new HashMap<Long, OperationTreeNode>();

    public synchronized void addOperationLog(OperationLog log) {
        if (log.getStatus() == OperationStatus.PENDING) {
            Operation operation = (Operation)log.getMessage();
            OperationTreeNode parent = this.nodes.get(operation.getParentId());
            OperationTreeNode node = new OperationTreeNode(log);
            if (parent == null) {
                if (this.root != null) {
                    throw new AssertionError((Object)("Parentless operation " + log));
                }
                logger.debug((Object)("adding root: " + operation.getName()));
                this.root = node;
                this.nodes.put(operation.getId(), node);
                this.fireTreeStructureChanged(new TreeModelEvent((Object)this, new Object[]{this.root}));
            } else {
                logger.debug((Object)("adding " + operation.getName() + " to " + parent.operation.getName()));
                parent.addChild(node);
                this.nodes.put(operation.getId(), node);
                this.fireTreeNodesInserted(new TreeModelEvent((Object)this, this.getPath(parent), new int[]{parent.getChildCount() - 1}, new Object[]{node}));
            }
        } else {
            OperationTreeNode node = this.nodes.get(log.getOperationId());
            logger.debug((Object)("changing: " + node.operation.getName()));
            node.currentStatus = log;
            this.fireTreeNodesChanged(new TreeModelEvent((Object)this, this.getPath(node)));
        }
    }

    public synchronized void addOperationLogs(List<OperationLog> operationLogs) {
        for (OperationLog log : operationLogs) {
            this.addOperationLog(log);
        }
    }

    private Object[] getPath(OperationTreeNode node) {
        ArrayList<OperationTreeNode> path = new ArrayList<OperationTreeNode>();
        path.add(0, node);
        while (node.operation.getParentId() != 0L) {
            node = this.nodes.get(node.operation.getParentId());
            path.add(0, node);
        }
        Object[] ret = new Object[path.size()];
        return path.toArray(ret);
    }

    @Override
    public Object getRoot() {
        return this.root;
    }

    @Override
    public Object getChild(Object parent, int index) {
        return ((OperationTreeNode)parent).children.get(index);
    }

    @Override
    public int getChildCount(Object parent) {
        return ((OperationTreeNode)parent).getChildCount();
    }

    @Override
    public boolean isLeaf(Object node) {
        return ((OperationTreeNode)node).isLeaf();
    }

    @Override
    public void valueForPathChanged(TreePath path, Object newValue) {
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        return ((OperationTreeNode)parent).children.indexOf(child);
    }

    public String toXML() {
        StringWriter stringWriter = new StringWriter();
        PrintWriter out = new PrintWriter(stringWriter);
        out.println("<operations>");
        this.toXML(1, this.root, out);
        out.println("</operations>");
        out.close();
        return stringWriter.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void toXML(int indent, OperationTreeNode node, PrintWriter out) {
        OperationStatus opStatus;
        int i;
        StringBuilder indentSB = new StringBuilder();
        for (int i2 = 0; i2 < indent; ++i2) {
            indentSB.append('\t');
        }
        String ind = indentSB.toString();
        out.println(ind + "<operation name=\"" + node.operation.getName() + "\"");
        Object[] params = node.operation.getNameParams();
        if (params != null) {
            for (i = 0; i < params.length; ++i) {
                params[i] = params[i] == null ? "" : OperationTree.normalize(params[i].toString());
                out.println(ind + "\tnameParam" + i + "=\"" + params[i] + "\"");
            }
        }
        if ((params = node.currentStatus.getParams()) != null) {
            for (i = 0; i < params.length; ++i) {
                params[i] = params[i] == null ? "" : OperationTree.normalize(params[i].toString());
                out.println(ind + "\tmessageParam" + i + "=\"" + params[i] + "\"");
            }
        }
        String status = (opStatus = node.currentStatus.getStatus()) == null ? "" : OperationTree.normalize(opStatus.toString());
        out.println(ind + "\tstatus=\"" + status + "\"");
        out.println(ind + "\tmessage=\"" + OperationTree.normalize(node.currentStatus.getMessageAsString()) + "\"");
        out.println(ind + "\ttime=\"" + OperationTree.normalize(new Date(node.currentStatus.getTime()).toString()) + "\">");
        if (!node.isLeaf()) {
            OperationTree operationTree = this;
            synchronized (operationTree) {
                for (OperationTreeNode child : node.children) {
                    this.toXML(indent + 1, child, out);
                }
            }
        }
        out.println(ind + "</operation>");
    }

    public static String normalize(String s) {
        StringBuilder str = new StringBuilder();
        int len = s == null ? 0 : s.length();
        block7: for (int i = 0; i < len; ++i) {
            char ch = s.charAt(i);
            switch (ch) {
                case '<': {
                    str.append("&lt;");
                    continue block7;
                }
                case '>': {
                    str.append("&gt;");
                    continue block7;
                }
                case '&': {
                    str.append("&amp;");
                    continue block7;
                }
                case '\"': {
                    str.append("&quot;");
                    continue block7;
                }
                case '\n': 
                case '\r': {
                    str.append("&#");
                    str.append(Integer.toString(ch));
                    str.append(';');
                    continue block7;
                }
                default: {
                    str.append(ch);
                }
            }
        }
        return str.toString();
    }

    public static class OperationTreeNode {
        Operation operation;
        OperationLog currentStatus;
        protected List<OperationTreeNode> children;

        public OperationTreeNode(OperationLog opPending) {
            this.operation = (Operation)opPending.getMessage();
            this.currentStatus = opPending;
        }

        public Operation getOperation() {
            return this.operation;
        }

        public synchronized void addChild(OperationTreeNode child) {
            if (this.children == null) {
                this.children = new ArrayList<OperationTreeNode>();
            }
            this.children.add(child);
        }

        public synchronized int getChildCount() {
            return this.children == null ? 0 : this.children.size();
        }

        public synchronized boolean isLeaf() {
            return this.children == null;
        }

        public String toString() {
            return this.operation.getName() + " - " + (this.currentStatus != null ? (Object)((Object)this.currentStatus.getStatus()) + " - " + this.currentStatus.getMessageAsString() : "");
        }

        public synchronized boolean isPending() {
            if (this.isLeaf()) {
                return this.currentStatus.getStatus() == OperationStatus.PENDING;
            }
            for (OperationTreeNode child : this.children) {
                if (child.isPending()) continue;
                return false;
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getPercentCompleted() {
            if (this.isLeaf()) {
                if (this.currentStatus.getStatus().isFinishedState()) {
                    return 100;
                }
                return 0;
            }
            OperationTreeNode operationTreeNode = this;
            synchronized (operationTreeNode) {
                int count = this.children.size();
                int sum = 0;
                for (OperationTreeNode child : this.children) {
                    sum += child.getPercentCompleted();
                }
                return sum / count;
            }
        }
    }
}

