/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.util.task;

import com.bwanms.model.TaskRuntimeStatus;
import com.bwanms.util.task.Operation;
import com.bwanms.util.task.OperationLog;
import com.bwanms.util.task.OperationStatus;
import com.bwanms.util.task.OperationTree;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OperationTaskRuntimeStatus {
    private ArrayList<OperationLog> operationLogs = new ArrayList();
    private transient OperationTree operationTree;

    public OperationTaskRuntimeStatus() {
        this.operationTree = new OperationTree();
    }

    public OperationTaskRuntimeStatus(Operation rootOperation) {
        this.operationLogs.add(new OperationLog(rootOperation, OperationStatus.PENDING, rootOperation, new Object[0]));
        this.operationTree = new OperationTree();
        this.operationTree.addOperationLogs(this.operationLogs);
    }

    public synchronized void append(TaskRuntimeStatusTransport diff) {
        this.operationLogs.addAll(diff.operationLogs);
        this.operationTree.addOperationLogs(diff.operationLogs);
    }

    public synchronized TaskRuntimeStatusTransport getDiff(int index) {
        if (index > this.operationLogs.size()) {
            return new TaskRuntimeStatusTransport();
        }
        return new TaskRuntimeStatusTransport(this.operationLogs.subList(index, this.operationLogs.size()));
    }

    public synchronized List<OperationLog> getDiffAsList(int index) {
        if (index > this.operationLogs.size()) {
            return new ArrayList<OperationLog>();
        }
        return new ArrayList<OperationLog>(this.operationLogs.subList(index, this.operationLogs.size()));
    }

    public synchronized Operation addOperation(Operation parent, String nameParams) {
        return this.addOperation(parent, nameParams, null);
    }

    public synchronized Operation addOperation(Operation parent, String name, Object ... params) {
        Operation ret = new Operation(parent, name, params);
        OperationLog log = new OperationLog(ret, OperationStatus.PENDING, ret, new Object[0]);
        this.operationLogs.add(log);
        this.operationTree.addOperationLog(log);
        return ret;
    }

    public synchronized void logOperationStatus(Operation operation, OperationStatus status) {
        this.logOperationStatus(operation, status, null);
    }

    public synchronized void logOperationStatus(Operation operation, OperationStatus status, Serializable message) {
        this.logOperationStatus(operation, status, message, new Object[0]);
    }

    public synchronized void logOperationStatus(Operation operation, OperationStatus status, Serializable message, Object ... messageParams) {
        OperationLog log = new OperationLog(operation, status, message, messageParams);
        this.operationLogs.add(log);
        this.operationTree.addOperationLog(log);
    }

    public synchronized int getOperationLogSize() {
        return this.operationLogs.size();
    }

    public OperationTree getOperationTree() {
        return this.operationTree;
    }

    public String toXMLString() {
        return this.operationTree.toXML();
    }

    public String toXMLStringFailed(String name) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter out = new PrintWriter(stringWriter);
        out.println("<operations>");
        out.println("<operation name=\"RbServiceProfileDistributionTaskWithName\"");
        out.println("nameParam0=\"" + name + "\"");
        out.println("status=\"failed\"");
        out.println("message=\"NoEquipmentInList\"");
        out.println("time=\"" + new Date().toString() + "\">");
        out.println("</operation>");
        out.println("</operations>");
        out.close();
        return stringWriter.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TaskRuntimeStatusTransport
    extends TaskRuntimeStatus
    implements Serializable {
        private static final long serialVersionUID = 4504297118412973781L;
        private ArrayList<OperationLog> operationLogs;

        public TaskRuntimeStatusTransport() {
            this.operationLogs = new ArrayList();
        }

        public TaskRuntimeStatusTransport(List<OperationLog> operationLogs) {
            this.operationLogs = new ArrayList<OperationLog>(operationLogs);
        }

        public List<OperationLog> getOperationLogs() {
            return this.operationLogs;
        }
    }
}

