/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.util.task;

import com.bwanms.gui.Internationalizer;
import java.io.Serializable;

public class Operation
implements Serializable {
    private static final long serialVersionUID = 5881134229330802690L;
    public static final long NO_PARENT = 0L;
    private static long idSequence = 1L;
    private long id = Operation.nextId();
    private long parentId = 0L;
    private String name;
    private Object[] nameParams;
    private Object[] messageParams;
    private int displayStyle = 3;
    public static final int DISPLAY_STYLE_PROGRESS = 1;
    public static final int DISPLAY_STYLE_PROGRESS_BAR = 2;

    private static synchronized long nextId() {
        return idSequence++;
    }

    public Operation(Operation parent, String name) {
        this(parent, name, null, null);
    }

    public Operation(Operation parent, String name, Object[] nameParams) {
        this(parent, name, nameParams, null);
    }

    public Operation(Operation parent, String name, Object[] nameParams, Object[] messageParams) {
        this.parentId = parent != null ? parent.id : 0L;
        this.name = name;
        this.nameParams = nameParams;
        this.messageParams = messageParams;
    }

    public long getId() {
        return this.id;
    }

    public String getName() {
        return this.name == null ? "" : this.name;
    }

    public String getTranslatedName(Internationalizer i18n) {
        if (i18n == null) {
            return this.getName();
        }
        return i18n.translateString(this.getName(), this.nameParams);
    }

    public long getParentId() {
        return this.parentId;
    }

    public Object[] getNameParams() {
        return this.nameParams == null ? null : (Object[])this.nameParams.clone();
    }

    public int getDisplayStyle() {
        return this.displayStyle;
    }

    public void setDisplayStyle(int displayStyle) {
        this.displayStyle = displayStyle;
    }
}

