/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.util.task;

import com.bwanms.gui.Internationalizer;
import com.bwanms.util.task.OperationTree;
import com.bwanms.util.task.OperationTreeCellRenderer;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.ArrayList;
import org.apache.log4j.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class InternationalizerHandler
extends DefaultHandler {
    private ByteArrayOutputStream strOut = new ByteArrayOutputStream();
    protected Writer out;
    protected static final Internationalizer localI18N = Internationalizer.getInternationalizer(OperationTreeCellRenderer.class);
    protected Internationalizer i18n;
    private static final Logger log = Logger.getLogger(InternationalizerHandler.class);

    public InternationalizerHandler(Internationalizer i18n) {
        this.i18n = i18n;
        try {
            this.out = new OutputStreamWriter((OutputStream)this.strOut, "UTF8");
        }
        catch (UnsupportedEncodingException e) {
            log.error((Object)"", (Throwable)e);
            this.out = new OutputStreamWriter(this.strOut);
        }
    }

    public void endDocument() throws SAXException {
        try {
            this.out.flush();
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        try {
            if ("operations".equals(qName)) {
                this.out.write("</operations>\n");
            } else if ("operation".equals(qName)) {
                this.out.write("</operation>\n");
            }
        }
        catch (IOException e) {
            log.debug((Object)"", (Throwable)e);
            throw new SAXException(e);
        }
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        try {
            if ("operations".equals(qName)) {
                this.out.write("<operations>\n");
            } else if ("operation".equals(qName)) {
                ArrayList<String> paramList = new ArrayList<String>();
                String param = null;
                int i = 0;
                while ((param = attributes.getValue("nameParam" + i)) != null) {
                    paramList.add(param);
                    ++i;
                }
                Object[] nameParams = new Object[paramList.size()];
                paramList.toArray(nameParams);
                paramList.clear();
                int i2 = 0;
                while ((param = attributes.getValue("messageParam" + i2)) != null) {
                    paramList.add(param);
                    ++i2;
                }
                Object[] messageParams = new Object[paramList.size()];
                paramList.toArray(messageParams);
                String name = OperationTree.normalize(this.i18n.translateString(attributes.getValue("name"), nameParams));
                String status = OperationTree.normalize(localI18N.translateString(attributes.getValue("status")));
                String message = OperationTree.normalize(this.i18n.translateString(attributes.getValue("message"), messageParams));
                StringBuffer result = new StringBuffer("<operation name=\"").append(name);
                result.append("\" status=\"").append(status);
                result.append("\" message=\"").append(message);
                result.append("\">\n");
                this.out.write(result.toString());
            }
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
    }

    public String getOutputString() throws IOException {
        this.strOut.flush();
        return this.strOut.toString("UTF8");
    }
}

