/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.util.marshalling;

import com.bwanms.performance.PMCollectionFactoriesProvider;
import com.bwanms.performance.export.model.MeasCollecFile;
import com.bwanms.tasks.pmcollection.MeasCollecContext;
import com.bwanms.util.marshalling.MeasCollecTransformer;
import com.bwanms.util.marshalling.spi.IMarshaller;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.datatype.DatatypeConfigurationException;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleJAXBMarshaller
implements IMarshaller {
    private static final Logger LOG = Logger.getLogger(SimpleJAXBMarshaller.class);
    MeasCollecContext ctx;
    private MeasCollecTransformer transformer;
    private Map<String, MeasCollecFile.MeasData.MeasInfo> oidsMeasInfos;
    private JAXBContext jaxbCtx;

    public SimpleJAXBMarshaller(MeasCollecContext ctx) {
        this.setCtx(ctx);
        this.transformer = PMCollectionFactoriesProvider.INSTANCE.getPMCollectionFactory().createTransformer(this.ctx);
    }

    @Override
    public byte[] marshal() {
        return this.doMarshall();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] doMarshall() {
        ByteArrayOutputStream byteArrayOS = null;
        byte[] out = null;
        try {
            LOG.debug((Object)"Creating JAXB context.");
            this.createJAXBContext();
            LOG.debug((Object)"JAXB context was created and cached..");
            MeasCollecFile collecFile = this.transformer.transform2CollecFile();
            LOG.debug((Object)"Counters measurements collection objects hierarchy was created.");
            Marshaller marshaller = this.jaxbCtx.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            byteArrayOS = new ByteArrayOutputStream();
            marshaller.marshal((Object)collecFile, (OutputStream)byteArrayOS);
            LOG.debug((Object)"Counters measurements collection objects hierarchy was marshalled.");
            out = byteArrayOS.toByteArray();
            LOG.debug((Object)"The counters measurements was successfully marshall into a byte array");
        }
        catch (JAXBException ex) {
            LOG.error((Object)ex.getMessage(), (Throwable)ex);
        }
        catch (DatatypeConfigurationException ex) {
            LOG.error((Object)ex.getMessage(), (Throwable)ex);
        }
        finally {
            if (byteArrayOS != null) {
                try {
                    byteArrayOS.close();
                    LOG.debug((Object)"The counters measurements byte array was successfully closed");
                }
                catch (IOException ex) {
                    LOG.error((Object)ex.getMessage(), (Throwable)ex);
                }
            }
        }
        LOG.debug((Object)"Counters measurements collection objects hierarchy was totally marshalled.");
        return out;
    }

    private void createJAXBContext() throws JAXBException {
        if (this.jaxbCtx == null) {
            try {
                this.jaxbCtx = JAXBContext.newInstance((String)"com.bwanms.performance.export.model");
            }
            catch (Throwable ex) {
                throw new JAXBException(String.format("Something really bad was happening. Exception message is: %s%n", ex.getMessage()), ex);
            }
        }
    }

    private void setCtx(MeasCollecContext ctx) {
        this.ctx = ctx;
    }

    private Map<String, MeasCollecFile.MeasData.MeasInfo> getOidsMeasInfos() {
        if (this.oidsMeasInfos == null) {
            this.oidsMeasInfos = new HashMap<String, MeasCollecFile.MeasData.MeasInfo>();
        }
        return this.oidsMeasInfos;
    }
}

