/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.util.marshalling;

import com.bwanms.performance.export.model.MeasCollecFile;
import com.bwanms.tasks.pmcollection.MeasCollecContext;
import com.bwanms.tasks.pmcollection.MultipleEntityMeasCollecCtx;
import com.bwanms.tasks.pmcollection.SingleEntityMeasCollecCtx;
import com.bwanms.util.marshalling.MeasCollecTransformer;
import java.util.Iterator;
import javax.xml.datatype.DatatypeConfigurationException;
import org.apache.log4j.Logger;
import org.snmp4j.event.ResponseEvent;

public class MultipleEntityMeasCollecTransformer
extends MeasCollecTransformer {
    private static final Logger LOG = Logger.getLogger((String)MultipleEntityMeasCollecTransformer.class.getName());

    public MultipleEntityMeasCollecTransformer(MeasCollecContext context) {
        super(context);
    }

    protected void transform2Body(MeasCollecFile collecFile) {
        try {
            Iterator<MeasCollecContext> it = this.getSpecificCtx().getChildren().iterator();
            boolean i = false;
            while (it.hasNext()) {
                MeasCollecContext context = it.next();
                if (!(context instanceof SingleEntityMeasCollecCtx)) {
                    throw new RuntimeException("The children context of a multiple entity context must be a single entity meas collec context");
                }
                SingleEntityMeasCollecCtx singleCtx = (SingleEntityMeasCollecCtx)context;
                MeasCollecFile.MeasData measData = this.transform2MeasData(singleCtx);
                collecFile.addMeasData(measData);
                for (ResponseEvent responseEvent : singleCtx.getResponseEvents()) {
                    MeasCollecFile.MeasData.MeasInfo transform2MeasInfo = this.transform2MeasInfo(responseEvent, singleCtx);
                    if (transform2MeasInfo == null) continue;
                    measData.addMeasInfo(transform2MeasInfo);
                }
            }
        }
        catch (DatatypeConfigurationException ex) {
            LOG.error((Object)ex.getMessage(), (Throwable)ex);
        }
    }

    private MultipleEntityMeasCollecCtx getSpecificCtx() {
        return (MultipleEntityMeasCollecCtx)this.ctx;
    }
}

