/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.util.marshalling;

import com.bwanms.performance.PerformanceCollectionActiveEntity;
import com.bwanms.performance.db.PmCollectionVariable;
import com.bwanms.performance.export.model.MeasCollecFile;
import com.bwanms.tasks.pmcollection.MeasCollecContext;
import com.bwanms.tasks.pmcollection.UserData;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Vector;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import org.snmp4j.event.ResponseEvent;
import org.snmp4j.smi.Integer32;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.VariableBinding;

public abstract class MeasCollecTransformer {
    protected MeasCollecContext ctx;
    private DatatypeFactory datatypeFactory;

    public MeasCollecTransformer(MeasCollecContext context) {
        this.ctx = context;
    }

    public MeasCollecFile transform2CollecFile() throws DatatypeConfigurationException {
        MeasCollecFile collecFile = new MeasCollecFile();
        collecFile.setFileHeader(this.transform2FileHeader(this.ctx));
        this.transform2Body(collecFile);
        collecFile.setFileFooter(this.transform2FileFooter());
        return collecFile;
    }

    protected abstract void transform2Body(MeasCollecFile var1);

    protected final MeasCollecFile.MeasData.MeasInfo transform2MeasInfo(ResponseEvent event, MeasCollecContext ctx) throws DatatypeConfigurationException {
        String inst;
        MeasCollecFile.MeasData.MeasInfo measInfo = new MeasCollecFile.MeasData.MeasInfo();
        Object[] crtRow = this.getCurrentCounterGroup(event);
        List vars = (List)crtRow[2];
        Vector variableBindings = event.getResponse().getVariableBindings();
        if (vars == null || vars.size() == 0 || variableBindings == null || variableBindings.size() == 0) {
            return null;
        }
        measInfo.setJob(this.transform2Job(ctx));
        measInfo.setGranPeriod(this.transform2GranPeriod(ctx, event));
        measInfo.setRepPeriod(this.transform2RepPeriod());
        String groupName = (String)crtRow[0];
        MeasCollecFile.MeasData.MeasInfo.MeasValue measValue = new MeasCollecFile.MeasData.MeasInfo.MeasValue();
        if (event.getRequest().getType() == -95 && (inst = MeasCollecTransformer.getInstance((PmCollectionVariable)vars.get(0), (VariableBinding)variableBindings.get(0))) != null && inst.length() > 0) {
            groupName = groupName + "." + inst;
        }
        measValue.setMeasObjLdn(groupName);
        for (int idx = 1; idx <= vars.size(); ++idx) {
            String[] tokens = ((PmCollectionVariable)vars.get(idx - 1)).getName().split("\\.");
            measInfo.addMeasType(new MeasCollecFile.MeasData.MeasInfo.MeasType(idx, tokens[0]));
            measValue.addR(new MeasCollecFile.MeasData.MeasInfo.MeasValue.R(idx, MeasCollecTransformer.getValue((VariableBinding)variableBindings.get(idx - 1))));
        }
        measInfo.addMeasValue(measValue);
        return measInfo;
    }

    protected final MeasCollecFile.MeasData transform2MeasData(MeasCollecContext ctx) {
        MeasCollecFile.MeasData measData = new MeasCollecFile.MeasData();
        measData.setManagedElement(this.transform2ManagedElement(ctx));
        return measData;
    }

    protected DatatypeFactory getDatatypeFactory() throws DatatypeConfigurationException {
        if (this.datatypeFactory == null) {
            this.datatypeFactory = DatatypeFactory.newInstance();
        }
        return this.datatypeFactory;
    }

    private MeasCollecFile.FileFooter transform2FileFooter() throws DatatypeConfigurationException {
        MeasCollecFile.FileFooter fileFooter = new MeasCollecFile.FileFooter();
        fileFooter.setMeasCollec(this.transform2FooterMeasCollec());
        return fileFooter;
    }

    private MeasCollecFile.FileHeader transform2FileHeader(MeasCollecContext ctx) throws DatatypeConfigurationException {
        MeasCollecFile.FileHeader fileHeader = new MeasCollecFile.FileHeader();
        fileHeader.setVendorName("Alvarion Ltd");
        fileHeader.setDnPrefix("DC=Alvarion.com,SubNetwork=ASN,IRPAgent=1");
        fileHeader.setFileFormatVersion("32.435 V7.1");
        fileHeader.setFileSender(this.transform2FileSender(ctx));
        fileHeader.setMeasCollec(this.transform2HeaderMeasCollec());
        return fileHeader;
    }

    private MeasCollecFile.FileFooter.MeasCollec transform2FooterMeasCollec() throws DatatypeConfigurationException {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(this.ctx.getEndTime());
        MeasCollecFile.FileFooter.MeasCollec measCollec = new MeasCollecFile.FileFooter.MeasCollec();
        measCollec.setEndTime(this.getDatatypeFactory().newXMLGregorianCalendar((GregorianCalendar)calendar));
        return measCollec;
    }

    private MeasCollecFile.FileHeader.FileSender transform2FileSender(MeasCollecContext ctx) {
        MeasCollecFile.FileHeader.FileSender fileSender = new MeasCollecFile.FileHeader.FileSender();
        fileSender.setElementType(this.getElementType(ctx));
        fileSender.setLocalDn(this.getFileHeaderLocalDN(ctx));
        return fileSender;
    }

    private MeasCollecFile.FileHeader.MeasCollec transform2HeaderMeasCollec() throws DatatypeConfigurationException {
        MeasCollecFile.FileHeader.MeasCollec measCollecHeader = new MeasCollecFile.FileHeader.MeasCollec();
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(this.ctx.getBeginTime());
        measCollecHeader.setBeginTime(this.getDatatypeFactory().newXMLGregorianCalendar((GregorianCalendar)calendar));
        return measCollecHeader;
    }

    private MeasCollecFile.MeasData.ManagedElement transform2ManagedElement(MeasCollecContext ctx) {
        MeasCollecFile.MeasData.ManagedElement managedElement = new MeasCollecFile.MeasData.ManagedElement();
        managedElement.setLocalDn(this.getManagedElementLocalDN(ctx));
        managedElement.setUserLabel(this.getUserLabel(ctx));
        managedElement.setSwVersion(ctx.getSwVersion());
        return managedElement;
    }

    private MeasCollecFile.MeasData.MeasInfo.Job transform2Job(MeasCollecContext ctx) {
        return new MeasCollecFile.MeasData.MeasInfo.Job(String.valueOf(ctx.getJobId()));
    }

    private MeasCollecFile.MeasData.MeasInfo.GranPeriod transform2GranPeriod(MeasCollecContext ctx, ResponseEvent event) throws DatatypeConfigurationException {
        Integer32 requestID = event.getResponse().getRequestID();
        Long timeStamp = ((UserData)event.getUserObject()).getTimeStamp(requestID);
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(timeStamp);
        return new MeasCollecFile.MeasData.MeasInfo.GranPeriod(this.getDatatypeFactory().newDuration(ctx.getGranularity() * 60 * 1000), this.getDatatypeFactory().newXMLGregorianCalendar((GregorianCalendar)calendar));
    }

    private MeasCollecFile.MeasData.MeasInfo.RepPeriod transform2RepPeriod() throws DatatypeConfigurationException {
        return new MeasCollecFile.MeasData.MeasInfo.RepPeriod(this.getDatatypeFactory().newDuration(900000L));
    }

    private String getElementType(MeasCollecContext ctx) {
        return ctx.getElementType();
    }

    private String getFileHeaderLocalDN(MeasCollecContext ctx2) {
        return String.format("SubNetwork=%s,MeContext=%s,ManagedElement=%s", "ASN", "", ctx2.getGroupUID());
    }

    private String getManagedElementLocalDN(MeasCollecContext ctx2) {
        return String.format("SubNetwork=%s,MeContext=%s,ManagedElement=%s", "ASN", "", ctx2.getElementUID());
    }

    private String getUserLabel(MeasCollecContext ctx) {
        return ctx.getElementName();
    }

    private Object[] getCurrentCounterGroup(ResponseEvent event) {
        UserData userData = (UserData)event.getUserObject();
        PerformanceCollectionActiveEntity activeEntity = userData.getActiveEntity();
        int countersIndex = userData.getCountersIndex();
        Object[] crtRow = activeEntity.getCounters().get(countersIndex);
        return crtRow;
    }

    static String getInstance(PmCollectionVariable var, VariableBinding vb) {
        String inst = "";
        OID baseOid = var.getOid();
        OID oid = vb.getOid();
        if (!oid.startsWith(baseOid)) {
            throw new IllegalArgumentException("INVALID OID: " + oid.toString() + " should start with: " + baseOid.toString());
        }
        String baseStr = baseOid.toString();
        String str = oid.toString();
        inst = str.substring(baseStr.length() + 1, str.length());
        return inst;
    }

    static String getValue(VariableBinding vb) {
        return vb.getVariable().toString();
    }
}

