/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.util.fault;

import com.bwanms.gui.Internationalizer;
import com.bwanms.protocols.snmp.VarBind;
import com.bwanms.protocols.snmp.VarBindList;
import com.bwanms.util.OctetString;
import java.io.BufferedReader;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.Hashtable;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;

public class TrapInternationalizer {
    private static final Logger log = Logger.getLogger(TrapInternationalizer.class);
    private static final Internationalizer eventDefinitions = Internationalizer.getInternationalizer("com.bwanms.event.eventDefinition");
    private static final Internationalizer eventI18N = Internationalizer.getInternationalizer("com.bwanms.event.eventTranslation");
    private static final Internationalizer ddiI18N = Internationalizer.getInternationalizer("com.bwanms.ddi");
    private static Hashtable<String, String> varBindCache = new Hashtable();

    private static String replaceTokensWithVarBinds(String source, VarBindList varBinds) {
        if (source.indexOf("${") == -1) {
            return source;
        }
        try {
            String line;
            StringWriter retStr = new StringWriter();
            PrintWriter ret = new PrintWriter(retStr);
            BufferedReader in = new BufferedReader(new StringReader(source));
            while ((line = in.readLine()) != null) {
                int startTokenIndex = line.indexOf("${");
                int endTokenIndex = -1;
                while (startTokenIndex != -1) {
                    ret.print(line.substring(endTokenIndex + 1, startTokenIndex));
                    endTokenIndex = line.indexOf("}", startTokenIndex);
                    String tokenVal = line.substring(startTokenIndex + 2, endTokenIndex);
                    ret.print(TrapInternationalizer.getVarBindValue(tokenVal, varBinds));
                    startTokenIndex = line.indexOf("${", endTokenIndex);
                }
                if (endTokenIndex + 1 >= line.length()) continue;
                ret.println(line.substring(endTokenIndex + 1));
            }
            ret.flush();
            retStr.flush();
            return retStr.toString().trim();
        }
        catch (Exception ex) {
            log.error((Object)ex, (Throwable)ex);
            return source;
        }
    }

    private static String getVarBindValue(String varBindName, VarBindList _vbList) {
        if (_vbList == null) {
            return varBindName;
        }
        String OID2 = varBindCache.get(varBindName);
        if (OID2 == null) {
            OID2 = eventDefinitions.translateString(varBindName);
            varBindCache.put(varBindName, OID2);
        }
        log.debug((Object)(varBindName + ":" + OID2));
        for (int i = 0; i < _vbList.size(); ++i) {
            VarBind varBind = _vbList.get(i);
            String vbOid = varBind.getOID();
            log.debug((Object)vbOid);
            int oidLen = OID2.length();
            int vbOidLen = vbOid.length();
            if (!(oidLen == vbOidLen && vbOid.equals(OID2) || oidLen > vbOidLen && OID2.startsWith(vbOid + ".")) && (oidLen >= vbOidLen || !vbOid.startsWith(OID2 + "."))) continue;
            if (varBind.getVariable() != null) {
                if (varBind.getType() == -128) {
                    return OctetString.toDisplayString(varBind.getVariable().toString());
                }
                return varBind.getVariable().toString();
            }
            return "";
        }
        return varBindName;
    }

    private static String processConditionals(String source) {
        StringBuffer ret = new StringBuffer();
        if (source.indexOf(91) == -1) {
            return source;
        }
        int startConditional = 0;
        int endConditional = -1;
        while ((startConditional = source.indexOf(91, endConditional)) != -1) {
            ret.append(source.substring(endConditional + 1, startConditional));
            endConditional = source.indexOf(93, startConditional);
            String conditional = source.substring(startConditional + 1, endConditional);
            StringTokenizer tokenizer = new StringTokenizer(conditional, ",");
            String condition = tokenizer.nextToken();
            String trueValue = tokenizer.nextToken().trim();
            int eqIndex = condition.indexOf(61);
            String lValue = condition.substring(0, eqIndex).trim();
            String rValue = condition.substring(eqIndex + 1).trim();
            if (lValue.equals(rValue)) {
                ret.append(trueValue);
                continue;
            }
            ret.append(tokenizer.hasMoreTokens() ? tokenizer.nextToken().trim() : "");
        }
        ret.append(source.substring(endConditional + 1));
        return ret.toString().trim();
    }

    public static String translateEventTitle(String eventTitle) {
        return eventI18N.translateString(eventTitle + ".name");
    }

    public static String translateEventDescription(String eventTitle) {
        return eventI18N.translateString(eventTitle + ".description");
    }

    public static String translateEventAdvisor(String eventTitle) {
        return eventI18N.translateString(eventTitle + ".note");
    }

    public static String translateEventTitle(String eventTitle, VarBindList eventInfoVarBindList) {
        if (eventI18N.canTranslate(eventTitle + ".name")) {
            String name = eventI18N.translateString(eventTitle + ".name");
            name = TrapInternationalizer.replaceTokensWithVarBinds(name, eventInfoVarBindList);
            name = TrapInternationalizer.processConditionals(name);
            return name;
        }
        log.debug((Object)("eventTitle.name: \"" + eventTitle + ".name\" wasn't translated"));
        return eventTitle;
    }

    public static String translateEventDescription(String eventTitle, VarBindList eventInfoVarBindList) {
        if (eventI18N.canTranslate(eventTitle + ".description")) {
            String name = eventI18N.translateString(eventTitle + ".description");
            name = TrapInternationalizer.replaceTokensWithVarBinds(name, eventInfoVarBindList);
            name = TrapInternationalizer.processConditionals(name);
            return name;
        }
        log.debug((Object)("eventTitle.description: \"" + eventTitle + ".description\" wasn't translated"));
        return eventTitle;
    }

    public static String translateEventAdvisor(String eventTitle, VarBindList eventInfoVarBindList) {
        if (eventI18N.canTranslate(eventTitle + ".note")) {
            String name = eventI18N.translateString(eventTitle + ".note");
            name = TrapInternationalizer.replaceTokensWithVarBinds(name, eventInfoVarBindList);
            name = TrapInternationalizer.processConditionals(name);
            return name;
        }
        log.debug((Object)("eventTitle.advisor: \"" + eventTitle + ".advisor\" wasn't translated"));
        return eventTitle;
    }
}

