/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.util.fault;

import com.bwanms.mediation.snmp.SNMPTrapV1AgentEvent;
import com.bwanms.model.fault.Event;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.log4j.Logger;

public class PropertyCorrelationUtil {
    private static final Logger log = Logger.getLogger(PropertyCorrelationUtil.class);
    private TreeMap<Integer, int[]> correlationMap = new TreeMap();

    public PropertyCorrelationUtil(InputStream in) throws IOException {
        this.configure(in);
    }

    private void configure(InputStream in) throws IOException {
        Properties properties = new Properties();
        properties.load(in);
        for (String string : properties.keySet()) {
            String value = properties.getProperty(string).trim();
            int trapSpecific = Integer.parseInt(string);
            if ("allopen".equalsIgnoreCase(value.trim())) {
                this.correlationMap.put(trapSpecific, new int[]{-1});
                continue;
            }
            String[] valueParts = value.split(",");
            if (valueParts.length <= 0) continue;
            TreeSet<Integer> treeSet = new TreeSet<Integer>();
            for (String valuePart : valueParts) {
                treeSet.add(Integer.parseInt(valuePart.trim()));
            }
            int[] correlated = new int[treeSet.size()];
            int j = 0;
            for (Integer correlatedClass : treeSet) {
                correlated[j++] = correlatedClass;
            }
            this.correlationMap.put(trapSpecific, correlated);
        }
    }

    public boolean accept(Event event) {
        return true;
    }

    public boolean filterAccept(Event event, Event candidate) {
        int i;
        int[] correlatedTrapSpecificIds = this.correlationMap.get(((SNMPTrapV1AgentEvent)event.getEventCause()).getSpecific());
        if (correlatedTrapSpecificIds == null) {
            log.debug((Object)"Correlated trap specific IDs is null");
            return false;
        }
        if (correlatedTrapSpecificIds[0] == -1) {
            return true;
        }
        int candidateTrapSpecificId = ((SNMPTrapV1AgentEvent)candidate.getEventCause()).getSpecific();
        for (i = 0; i < correlatedTrapSpecificIds.length && correlatedTrapSpecificIds[i] < candidateTrapSpecificId; ++i) {
        }
        return i < correlatedTrapSpecificIds.length && correlatedTrapSpecificIds[i] == candidateTrapSpecificId;
    }
}

