/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.util.fault;

import com.bwanms.model.fault.nbi.Nbi;
import com.bwanms.model.fault.nbi.NbiPolicy;
import com.bwanms.model.fault.nbi.NbiPolicyFilterEquipment;
import com.bwanms.model.fault.nbi.NbiPolicyFilterEventCategory;
import com.bwanms.model.fault.nbi.NbiPolicyFilterEventType;
import com.bwanms.model.fault.nbi.NbiPolicyFilterEvtOID;
import com.bwanms.model.fault.nbi.NbiPolicyFilterLocation;
import com.bwanms.model.fault.nbi.NbiPolicyFilterMOAlias;
import com.bwanms.model.fault.nbi.NbiPolicyFilterMOInst;
import com.bwanms.model.fault.nbi.NbiPolicyFilterMOType;
import com.bwanms.model.fault.nbi.NbiPolicyFilterNEType;
import com.bwanms.model.fault.nbi.NbiPolicyFilterSeverity;
import com.bwanms.model.fault.nbi.NbiPolicyTimeDays;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class NBIUtil {
    private NBIUtil() {
    }

    public static Collection<String> getEventOIDs(Set<NbiPolicyFilterEvtOID> eventOIDs) {
        ArrayList<String> evtOIDs = new ArrayList<String>();
        for (NbiPolicyFilterEvtOID eventOID : eventOIDs) {
            evtOIDs.add(eventOID.getEventOID());
        }
        return evtOIDs;
    }

    public static Collection<Byte> getEventCategories(Set<NbiPolicyFilterEventCategory> eventCategories) {
        ArrayList<Byte> retEvtCategories = new ArrayList<Byte>();
        for (NbiPolicyFilterEventCategory evtCat : eventCategories) {
            retEvtCategories.add(evtCat.getEventCategory());
        }
        return retEvtCategories;
    }

    public static Collection<Integer> getEventTypes(Set<NbiPolicyFilterEventType> eventTypes) {
        ArrayList<Integer> retEventTypes = new ArrayList<Integer>();
        for (NbiPolicyFilterEventType evtType : eventTypes) {
            retEventTypes.add(Integer.valueOf(evtType.getEventType()));
        }
        return retEventTypes;
    }

    public static Collection<Byte> getMoTypes(Set<NbiPolicyFilterMOType> moTypes) {
        ArrayList<Byte> retMoTypes = new ArrayList<Byte>();
        for (NbiPolicyFilterMOType moType : moTypes) {
            retMoTypes.add(moType.getMoType());
        }
        return retMoTypes;
    }

    public static Collection<String> getMoInstances(Set<NbiPolicyFilterMOInst> moInstances) {
        ArrayList<String> retMoInstances = new ArrayList<String>(moInstances.size());
        for (NbiPolicyFilterMOInst moInst : moInstances) {
            retMoInstances.add(moInst.getMoInst());
        }
        return retMoInstances;
    }

    public static Collection<String> getMoAliases(Set<NbiPolicyFilterMOAlias> moAliases) {
        ArrayList<String> retMoAliases = new ArrayList<String>(moAliases.size());
        for (NbiPolicyFilterMOAlias moAlias : moAliases) {
            retMoAliases.add(moAlias.getMoAlias());
        }
        return retMoAliases;
    }

    public static Collection<Integer> getNeTypes(Set<NbiPolicyFilterNEType> neTypes) {
        ArrayList<Integer> retNETypes = new ArrayList<Integer>();
        for (NbiPolicyFilterNEType neType : neTypes) {
            retNETypes.add(Integer.valueOf(neType.getNeType()));
        }
        return retNETypes;
    }

    public static Collection<Long> getLocationIds(Set<NbiPolicyFilterLocation> locations) {
        ArrayList<Long> locIds = new ArrayList<Long>();
        for (NbiPolicyFilterLocation location : locations) {
            locIds.add(location.getLocationID());
        }
        return locIds;
    }

    public static Collection<Byte> getSeverities(Set<NbiPolicyFilterSeverity> severities) {
        ArrayList<Byte> ret = new ArrayList<Byte>();
        for (NbiPolicyFilterSeverity severity : severities) {
            ret.add(severity.getSeverity());
        }
        return ret;
    }

    public static Collection<Integer> getDays(Collection<NbiPolicyTimeDays> days) {
        ArrayList<Integer> ret = new ArrayList<Integer>(7);
        for (NbiPolicyTimeDays day : days) {
            ret.add(day.getDay());
        }
        return ret;
    }

    public static Collection<Long> getEquipmentIds(Set<NbiPolicyFilterEquipment> equipments) {
        ArrayList<Long> ret = new ArrayList<Long>();
        for (NbiPolicyFilterEquipment equipment : equipments) {
            ret.add(equipment.getEquipmentID());
        }
        return ret;
    }

    public static boolean isNBIEnabled(Nbi nbi) {
        if (nbi.getEnabled() == 0) {
            return false;
        }
        for (NbiPolicy policy : nbi.getPolicies()) {
            if (policy.getEnabled() == 0) continue;
            return true;
        }
        return false;
    }
}

