/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.util.fault;

import com.bwanms.gui.Internationalizer;
import com.bwanms.model.fault.Event;
import com.bwanms.model.fault.EventFilter;
import com.bwanms.model.fault.EvtFilterEquipment;
import com.bwanms.model.fault.EvtFilterEventCategory;
import com.bwanms.model.fault.EvtFilterEventType;
import com.bwanms.model.fault.EvtFilterEvtOID;
import com.bwanms.model.fault.EvtFilterLocation;
import com.bwanms.model.fault.EvtFilterMOAlias;
import com.bwanms.model.fault.EvtFilterMOInst;
import com.bwanms.model.fault.EvtFilterMOType;
import com.bwanms.model.fault.EvtFilterNEType;
import com.bwanms.model.fault.EvtFilterSeverity;
import com.bwanms.model.fault.constants.EventCategory;
import com.bwanms.model.fault.constants.EventType;
import com.bwanms.model.fault.constants.Severity;
import com.bwanms.model.fault.constants.UserClassifier;
import com.bwanms.security.Security;
import com.bwanms.util.PluginUtil;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.Set;

public final class FilterUtil {
    private static final SimpleDateFormat df = new SimpleDateFormat("dd-MM-yyyy HH:mm:ss");
    private static final Internationalizer i18nConstants = Internationalizer.getInternationalizer("com.bwanms.faultConstants");
    private static String openAlarmsFilter = Event.Property.equipmentId.columnName() + " = %s" + " AND " + Event.Property.eventCategory.columnName() + " = " + EventCategory.Alarm.byteValue() + " AND " + Event.Property.eventSeverity.columnName() + " != " + Severity.Cleared.byteValue() + " AND " + Event.Property.clearedBy.columnName() + " IS NULL ";

    public static boolean checkOwner(EventFilter filter) {
        String currentUser = Security.getSecurity().getCurrentUserId();
        if (currentUser == null) {
            return true;
        }
        return currentUser.equals(filter.getOwner());
    }

    public static String formatCreationDate(long timestamp) {
        return timestamp > 0L ? df.format(new Date(timestamp)) : "";
    }

    public static String formatFilter(EventFilter filter, boolean applyOnHistory) {
        String userClassifier;
        Set<EvtFilterSeverity> severities;
        Set<EvtFilterEventType> eventTypes;
        Set<EvtFilterEventCategory> evtCategories;
        Set<EvtFilterLocation> locations;
        int i;
        Iterator<Serializable> it;
        Set<EvtFilterEquipment> equipments;
        Set<EvtFilterEvtOID> eventOIDs;
        Set<EvtFilterMOAlias> moAliases;
        Set<EvtFilterMOInst> moInstances;
        Set<EvtFilterMOType> moTypes;
        int size;
        if (filter == null) {
            return null;
        }
        StringBuilder buffer = new StringBuilder();
        Set<EvtFilterNEType> neTypes = filter.getNeTypes();
        int n = size = neTypes != null ? neTypes.size() : -1;
        if (size > 0) {
            if (size == 1) {
                buffer.append(Event.Property.equipmentType.columnName()).append("=").append(neTypes.iterator().next().getNeType()).append(" AND ");
            } else {
                buffer.append(Event.Property.equipmentType.columnName()).append(" IN (");
                Iterator<EvtFilterNEType> it2 = neTypes.iterator();
                for (int i2 = 0; it2.hasNext() && i2 < size - 1; ++i2) {
                    buffer.append(it2.next().getNeType()).append(",");
                }
                if (it2.hasNext()) {
                    buffer.append(it2.next().getNeType());
                }
                buffer.append(") AND ");
            }
        }
        int n2 = size = (moTypes = filter.getMoTypes()) != null ? moTypes.size() : -1;
        if (size > 0) {
            if (size == 1) {
                buffer.append(Event.Property.moType.columnName()).append("=").append(moTypes.iterator().next().getMoType()).append(" AND ");
            } else {
                buffer.append(Event.Property.moType.columnName()).append(" IN (");
                Iterator<EvtFilterMOType> it3 = moTypes.iterator();
                for (int i3 = 0; it3.hasNext() && i3 < size - 1; ++i3) {
                    buffer.append(it3.next().getMoType()).append(",");
                }
                if (it3.hasNext()) {
                    buffer.append(it3.next().getMoType());
                }
                buffer.append(") AND ");
            }
        }
        int n3 = size = (moInstances = filter.getMoInstances()) != null ? moInstances.size() : -1;
        if (size > 0) {
            if (size == 1) {
                buffer.append(Event.Property.moInstance.columnName()).append("=").append("'").append(moInstances.iterator().next().getMoInst()).append("'").append(" AND ");
            } else {
                buffer.append(Event.Property.moInstance.columnName()).append(" IN (");
                Iterator<EvtFilterMOInst> it4 = moInstances.iterator();
                for (int i4 = 0; it4.hasNext() && i4 < size - 1; ++i4) {
                    buffer.append("'").append(it4.next().getMoInst()).append("'").append(",");
                }
                if (it4.hasNext()) {
                    buffer.append("'").append(it4.next().getMoInst()).append("'");
                }
                buffer.append(") AND ");
            }
        }
        int n4 = size = (moAliases = filter.getMoAliases()) != null ? moAliases.size() : -1;
        if (size > 0) {
            if (size == 1) {
                String alias = moAliases.iterator().next().getMoAlias();
                if (alias.contains("*")) {
                    buffer.append(Event.Property.moAlias.columnName()).append(" LIKE ").append("'").append(alias.replace('*', '%')).append("'").append(" AND ");
                } else {
                    buffer.append(Event.Property.moAlias.columnName()).append("=").append("'").append(moAliases.iterator().next().getMoAlias()).append("'").append(" AND ");
                }
            } else {
                buffer.append(Event.Property.moAlias.columnName()).append(" IN (");
                Iterator<EvtFilterMOAlias> it5 = moAliases.iterator();
                for (int i5 = 0; it5.hasNext() && i5 < size - 1; ++i5) {
                    buffer.append("'").append(it5.next().getMoAlias()).append("'").append(",");
                }
                if (it5.hasNext()) {
                    buffer.append("'").append(it5.next().getMoAlias()).append("'");
                }
                buffer.append(") AND ");
            }
        }
        int n5 = size = (eventOIDs = filter.getEventOIDs()) != null ? eventOIDs.size() : -1;
        if (size > 0) {
            if (size == 1) {
                buffer.append(Event.Property.eventOID.columnName()).append("=").append("'").append(eventOIDs.iterator().next().getEventOID()).append("'").append(" AND ");
            } else {
                buffer.append(Event.Property.eventOID.columnName()).append(" IN (");
                Iterator<EvtFilterEvtOID> it6 = eventOIDs.iterator();
                for (int i6 = 0; it6.hasNext() && i6 < size - 1; ++i6) {
                    buffer.append("'").append(it6.next().getEventOID()).append("'").append(",");
                }
                if (it6.hasNext()) {
                    buffer.append("'").append(it6.next().getEventOID()).append("'");
                }
                buffer.append(") AND ");
            }
        }
        int n6 = size = (equipments = filter.getEquipmentIDs()) != null ? equipments.size() : -1;
        if (size > 0) {
            if (size == 1) {
                EvtFilterEquipment criterion = equipments.iterator().next();
                buffer.append("( ").append(Event.Property.equipmentId.columnName()).append(" = ").append(criterion.getEquipmentID()).append(" OR ").append(Event.Property.moAlias.columnName()).append(" = '").append(criterion.getEquipmentName()).append("') AND ");
            } else {
                StringBuilder tempBuffer = new StringBuilder();
                buffer.append("( ").append(Event.Property.equipmentId.columnName()).append(" IN (");
                tempBuffer.append(") OR ").append(Event.Property.moAlias.columnName()).append(" IN (");
                it = equipments.iterator();
                EvtFilterEquipment equip = null;
                for (i = 0; it.hasNext() && i < size - 1; ++i) {
                    equip = (EvtFilterEquipment)it.next();
                    buffer.append(equip.getEquipmentID()).append(",");
                    tempBuffer.append("'").append(equip.getEquipmentName()).append("',");
                }
                if (it.hasNext()) {
                    equip = (EvtFilterEquipment)it.next();
                    buffer.append(equip.getEquipmentID());
                    tempBuffer.append("'").append(equip.getEquipmentName()).append("')) AND ");
                }
                buffer.append((CharSequence)tempBuffer);
            }
        }
        int n7 = size = (locations = filter.getLocationIDs()) != null ? locations.size() : -1;
        if (size > 0) {
            if (size == 1) {
                buffer.append(Event.Property.locationId.columnName()).append("=").append(locations.iterator().next().getLocationID()).append(" AND ");
            } else {
                buffer.append(Event.Property.locationId.columnName()).append(" IN (");
                it = locations.iterator();
                for (i = 0; it.hasNext() && i < size - 1; ++i) {
                    buffer.append(((EvtFilterLocation)it.next()).getLocationID()).append(",");
                }
                if (it.hasNext()) {
                    buffer.append(((EvtFilterLocation)it.next()).getLocationID());
                }
                buffer.append(") AND ");
            }
        }
        int n8 = size = (evtCategories = filter.getEventCategories()) != null ? evtCategories.size() : -1;
        if (size > 0) {
            if (size == 1) {
                buffer.append(Event.Property.eventCategory.columnName()).append("=").append(evtCategories.iterator().next().getEventCategory()).append(" AND ");
            } else {
                buffer.append(Event.Property.eventCategory.columnName()).append(" IN (");
                Iterator<EvtFilterEventCategory> it7 = evtCategories.iterator();
                for (int i7 = 0; it7.hasNext() && i7 < size - 1; ++i7) {
                    buffer.append(it7.next().getEventCategory()).append(",");
                }
                if (it7.hasNext()) {
                    buffer.append(it7.next().getEventCategory());
                }
                buffer.append(") AND ");
            }
        }
        int n9 = size = (eventTypes = filter.getEventTypes()) != null ? eventTypes.size() : -1;
        if (size > 0) {
            if (size == 1) {
                buffer.append(Event.Property.eventType.columnName()).append("=").append(eventTypes.iterator().next().getEventType()).append(" AND ");
            } else {
                buffer.append(Event.Property.eventType.columnName()).append(" IN (");
                Iterator<EvtFilterEventType> it8 = eventTypes.iterator();
                for (int i8 = 0; it8.hasNext() && i8 < size - 1; ++i8) {
                    buffer.append(it8.next().getEventType()).append(",");
                }
                if (it8.hasNext()) {
                    buffer.append(it8.next().getEventType());
                }
                buffer.append(") AND ");
            }
        }
        int n10 = size = (severities = filter.getSeverities()) != null ? severities.size() : -1;
        if (size > 0) {
            if (size == 1) {
                buffer.append(Event.Property.eventSeverity.columnName()).append("=").append(severities.iterator().next().getSeverity()).append(" AND ");
            } else {
                buffer.append(Event.Property.eventSeverity.columnName()).append(" IN (");
                Iterator<EvtFilterSeverity> it9 = severities.iterator();
                for (int i9 = 0; it9.hasNext() && i9 < size - 1; ++i9) {
                    buffer.append(it9.next().getSeverity()).append(",");
                }
                if (it9.hasNext()) {
                    buffer.append(it9.next().getSeverity());
                }
                buffer.append(") AND ");
            }
        }
        if ((userClassifier = filter.getUserClassifier()) != null && userClassifier.length() > 0 && !UserClassifier.none.name().equals(userClassifier)) {
            buffer.append(Event.Property.userClassifier.columnName()).append(" = '").append(userClassifier).append("' AND ");
        }
        if (filter.isAcknowledged()) {
            if (applyOnHistory) {
                buffer.append("(").append(Event.Property.ackedBy.columnName()).append(" != '").append("<null>").append("') AND ");
            } else {
                buffer.append("(").append(Event.Property.ackedBy.columnName()).append(" IS NOT NULL) AND ");
            }
        }
        if (filter.isCleared()) {
            if (applyOnHistory) {
                buffer.append("(").append(Event.Property.clearedBy.columnName()).append(" != '").append("<null>").append("') AND ");
            } else {
                buffer.append("(").append(Event.Property.clearedBy.columnName()).append(" IS NOT NULL) AND ");
            }
        }
        FilterUtil.formatFilterToolTip(filter, applyOnHistory);
        if (buffer.length() > 5) {
            return buffer.substring(0, buffer.length() - 5);
        }
        return null;
    }

    public static String getTimeCriteria(long fromDate, long toDate) {
        String receiveTimeCol = Event.Property.receiveTime.columnName();
        if (toDate > fromDate) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("( ").append(receiveTimeCol).append(" >= ").append(fromDate).append(" AND ").append(receiveTimeCol).append(" <= ").append(toDate).append(" )");
            return buffer.toString();
        }
        return null;
    }

    public static String formatOpenAlarmsFilter(long equipmentId) {
        return String.format(openAlarmsFilter, equipmentId);
    }

    public static String formatFilterToolTip(EventFilter filter, boolean applyOnHistory) {
        String userClassifier;
        Set<EvtFilterSeverity> severities;
        Set<EvtFilterEventType> eventTypes;
        Set<EvtFilterEventCategory> evtCategories;
        Set<EvtFilterLocation> locations;
        Set<EvtFilterEquipment> equipments;
        Set<EvtFilterEvtOID> eventOIDs;
        Set<EvtFilterMOAlias> moAliases;
        Set<EvtFilterMOInst> moInstances;
        Set<EvtFilterMOType> moTypes;
        int size;
        if (filter == null) {
            return null;
        }
        StringBuilder buffer = new StringBuilder();
        Set<EvtFilterNEType> neTypes = filter.getNeTypes();
        int n = size = neTypes != null ? neTypes.size() : -1;
        if (size > 0) {
            buffer.append("<html>");
            if (size == 1) {
                buffer.append(FilterUtil.formatPropertyName(Event.Property.equipmentType)).append(" = ").append(FilterUtil.formatPropertyValue(PluginUtil.getNEType(neTypes.iterator().next().getNeType()).toString())).append(" AND ").append("<br>");
            } else {
                buffer.append(FilterUtil.formatPropertyName(Event.Property.equipmentType)).append(" IN (");
                Iterator<EvtFilterNEType> it = neTypes.iterator();
                for (int i = 0; it.hasNext() && i < size - 1; ++i) {
                    buffer.append(FilterUtil.formatPropertyValue(PluginUtil.getNEType(it.next().getNeType()).toString())).append(", ");
                }
                if (it.hasNext()) {
                    buffer.append(FilterUtil.formatPropertyValue(PluginUtil.getNEType(it.next().getNeType()).toString()));
                }
                buffer.append(") AND ").append("<br>");
            }
        }
        int n2 = size = (moTypes = filter.getMoTypes()) != null ? moTypes.size() : -1;
        if (size > 0) {
            buffer.append("<html>");
            if (size == 1) {
                String moTypeStringValue = "" + PluginUtil.getMOType(FilterUtil.fixMoTypeValue(moTypes.iterator().next().getMoType()));
                buffer.append(FilterUtil.formatPropertyName(Event.Property.moType)).append(" = ").append(FilterUtil.formatPropertyValue(moTypeStringValue)).append(" AND ").append("<br>");
            } else {
                String moTypeStringValue;
                buffer.append(FilterUtil.formatPropertyName(Event.Property.moType)).append(" IN (");
                Iterator<EvtFilterMOType> it = moTypes.iterator();
                for (int i = 0; it.hasNext() && i < size - 1; ++i) {
                    moTypeStringValue = "" + PluginUtil.getMOType(FilterUtil.fixMoTypeValue(it.next().getMoType()));
                    buffer.append(FilterUtil.formatPropertyValue(moTypeStringValue)).append(",");
                }
                if (it.hasNext()) {
                    moTypeStringValue = "" + PluginUtil.getMOType(FilterUtil.fixMoTypeValue(it.next().getMoType()));
                    buffer.append(FilterUtil.formatPropertyValue(moTypeStringValue));
                }
                buffer.append(") AND ").append("<br>");
            }
        }
        int n3 = size = (moInstances = filter.getMoInstances()) != null ? moInstances.size() : -1;
        if (size > 0) {
            buffer.append("<html>");
            if (size == 1) {
                buffer.append(FilterUtil.formatPropertyName(Event.Property.moInstance)).append(" = ").append(moInstances.iterator().next().getMoInst()).append(" AND ").append("<br>");
            } else {
                buffer.append(FilterUtil.formatPropertyName(Event.Property.moInstance)).append(" IN (");
                Iterator<EvtFilterMOInst> it = moInstances.iterator();
                for (int i = 0; it.hasNext() && i < size - 1; ++i) {
                    buffer.append(it.next().getMoInst()).append(",");
                }
                if (it.hasNext()) {
                    buffer.append(it.next().getMoInst());
                }
                buffer.append(") AND ").append("<br>");
            }
        }
        int n4 = size = (moAliases = filter.getMoAliases()) != null ? moAliases.size() : -1;
        if (size > 0) {
            buffer.append("<html>");
            if (size == 1) {
                String alias = moAliases.iterator().next().getMoAlias();
                if (alias.contains("*")) {
                    buffer.append("<b>Alias</b>").append(" LIKE ").append("'").append(alias.replace('*', '%')).append("'").append(" AND ").append("<br>");
                } else {
                    buffer.append(FilterUtil.formatPropertyName(Event.Property.moAlias)).append("=").append("'").append(moAliases.iterator().next().getMoAlias()).append("'").append(" AND ").append("<br>");
                }
            } else {
                buffer.append(FilterUtil.formatPropertyName(Event.Property.moAlias)).append(" IN (");
                Iterator<EvtFilterMOAlias> it = moAliases.iterator();
                for (int i = 0; it.hasNext() && i < size - 1; ++i) {
                    buffer.append(it.next().getMoAlias()).append(",");
                }
                if (it.hasNext()) {
                    buffer.append(it.next().getMoAlias());
                }
                buffer.append(") AND ").append("<br>");
            }
        }
        int n5 = size = (eventOIDs = filter.getEventOIDs()) != null ? eventOIDs.size() : -1;
        if (size > 0) {
            buffer.append("<html>");
            if (size == 1) {
                buffer.append(FilterUtil.formatPropertyName(Event.Property.eventOID)).append(" = ").append(eventOIDs.iterator().next().getEventOID()).append(" AND ").append("<br>");
            } else {
                buffer.append(FilterUtil.formatPropertyName(Event.Property.eventOID)).append(" IN (");
                Iterator<EvtFilterEvtOID> it = eventOIDs.iterator();
                for (int i = 0; it.hasNext() && i < size - 1; ++i) {
                    buffer.append(it.next().getEventOID()).append(",");
                }
                if (it.hasNext()) {
                    buffer.append(it.next().getEventOID());
                }
                buffer.append(") AND ").append("<br>");
            }
        }
        int n6 = size = (equipments = filter.getEquipmentIDs()) != null ? equipments.size() : -1;
        if (size > 0) {
            buffer.append("<html>");
            if (size == 1) {
                buffer.append(FilterUtil.formatPropertyName(Event.Property.equipmentName)).append(" = ").append(FilterUtil.formatEquipmentName(equipments.iterator().next())).append(" AND ").append("<br>");
            } else {
                buffer.append(FilterUtil.formatPropertyName(Event.Property.equipmentName)).append(" IN (");
                Iterator<EvtFilterEquipment> it = equipments.iterator();
                for (int i = 0; it.hasNext() && i < size - 1; ++i) {
                    buffer.append(FilterUtil.formatEquipmentName(it.next())).append(",");
                }
                if (it.hasNext()) {
                    buffer.append(FilterUtil.formatEquipmentName(it.next()));
                }
                buffer.append(") AND ").append("<br>");
            }
        }
        int n7 = size = (locations = filter.getLocationIDs()) != null ? locations.size() : -1;
        if (size > 0) {
            buffer.append("<html>");
            if (size == 1) {
                buffer.append(FilterUtil.formatPropertyName(Event.Property.locationName)).append(" = ").append(locations.iterator().next().getLocationName()).append(" AND ").append("<br>");
            } else {
                buffer.append(FilterUtil.formatPropertyName(Event.Property.locationName)).append(" IN (");
                Iterator<EvtFilterLocation> it = locations.iterator();
                for (int i = 0; it.hasNext() && i < size - 1; ++i) {
                    buffer.append(it.next().getLocationName()).append(",");
                }
                if (it.hasNext()) {
                    buffer.append(it.next().getLocationName());
                }
                buffer.append(") AND ").append("<br>");
            }
        }
        int n8 = size = (evtCategories = filter.getEventCategories()) != null ? evtCategories.size() : -1;
        if (size > 0) {
            buffer.append("<html>");
            if (size == 1) {
                EventCategory category = EventCategory.fromValue(evtCategories.iterator().next().getEventCategory());
                buffer.append(FilterUtil.formatPropertyName(Event.Property.eventCategory)).append(" = ").append(FilterUtil.formatPropertyValue(category.toString())).append(" AND ").append("<br>");
            } else {
                buffer.append(FilterUtil.formatPropertyName(Event.Property.eventCategory)).append(" IN (");
                Iterator<EvtFilterEventCategory> it = evtCategories.iterator();
                EventCategory category = null;
                for (int i = 0; it.hasNext() && i < size - 1; ++i) {
                    category = EventCategory.fromValue(it.next().getEventCategory());
                    buffer.append(FilterUtil.formatPropertyValue(category.toString())).append(",");
                }
                if (it.hasNext()) {
                    category = EventCategory.fromValue(it.next().getEventCategory());
                    buffer.append(FilterUtil.formatPropertyValue(category.toString()));
                }
                buffer.append(") AND ").append("<br>");
            }
        }
        int n9 = size = (eventTypes = filter.getEventTypes()) != null ? eventTypes.size() : -1;
        if (size > 0) {
            buffer.append("<html>");
            if (size == 1) {
                EventType eventType = EventType.fromValue(eventTypes.iterator().next().getEventType());
                buffer.append(FilterUtil.formatPropertyName(Event.Property.eventType)).append(" = ").append(FilterUtil.formatPropertyValue(eventType.toString())).append(" AND ").append("<br>");
            } else {
                buffer.append(FilterUtil.formatPropertyName(Event.Property.eventType)).append(" IN (");
                Iterator<EvtFilterEventType> it = eventTypes.iterator();
                EventType eventType = null;
                for (int i = 0; it.hasNext() && i < size - 1; ++i) {
                    eventType = EventType.fromValue(it.next().getEventType());
                    buffer.append(FilterUtil.formatPropertyValue(eventType.toString())).append(",");
                }
                if (it.hasNext()) {
                    eventType = EventType.fromValue(it.next().getEventType());
                    buffer.append(FilterUtil.formatPropertyValue(eventType.toString()));
                }
                buffer.append(") AND ").append("<br>");
            }
        }
        int n10 = size = (severities = filter.getSeverities()) != null ? severities.size() : -1;
        if (size > 0) {
            buffer.append("<html>");
            if (size == 1) {
                Severity severity = Severity.fromValue(severities.iterator().next().getSeverity());
                buffer.append(FilterUtil.formatPropertyName(Event.Property.eventSeverity)).append(" = ").append(FilterUtil.formatPropertyValue(severity.toString())).append(" AND ").append("<br>");
            } else {
                buffer.append(FilterUtil.formatPropertyName(Event.Property.eventSeverity)).append(" IN (");
                Iterator<EvtFilterSeverity> it = severities.iterator();
                Severity severity = null;
                for (int i = 0; it.hasNext() && i < size - 1; ++i) {
                    severity = Severity.fromValue(it.next().getSeverity());
                    buffer.append(FilterUtil.formatPropertyValue(severity.toString())).append(",");
                }
                if (it.hasNext()) {
                    severity = Severity.fromValue(it.next().getSeverity());
                    buffer.append(FilterUtil.formatPropertyValue(severity.toString()));
                }
                buffer.append(") AND ").append("<br>");
            }
        }
        if ((userClassifier = filter.getUserClassifier()) != null && userClassifier.length() > 0 && !UserClassifier.none.name().equals(userClassifier)) {
            buffer.append("<html>");
            buffer.append(FilterUtil.formatPropertyName(Event.Property.userClassifier)).append(" = ").append(userClassifier).append(" AND ").append("<br>");
        }
        if (filter.isAcknowledged()) {
            buffer.append("<html>");
            buffer.append(FilterUtil.formatPropertyName(Event.Property.ackedBy)).append(" IS NOT NULL AND ").append("<br>");
        }
        if (filter.isCleared()) {
            buffer.append("<html>");
            buffer.append(FilterUtil.formatPropertyName(Event.Property.clearedBy)).append(" IS NOT NULL AND ").append("<br>");
        }
        if (buffer.length() > 5) {
            String buf = buffer.substring(0, buffer.length() - 9);
            StringBuilder bufFinal = new StringBuilder(buf);
            bufFinal = bufFinal.append("<br>");
            return bufFinal.toString();
        }
        return null;
    }

    public static int fixMoTypeValue(byte moTypeValue) {
        return moTypeValue < 0 ? 256 + moTypeValue : moTypeValue;
    }

    private static String formatPropertyName(Event.Property prop) {
        return new StringBuffer("<b>").append(i18nConstants.translateString("Event.Property." + prop.name())).append("</b>").toString();
    }

    private static String formatPropertyValue(String prop) {
        return new StringBuffer("").append(i18nConstants.translateString(prop)).toString();
    }

    private static String formatEquipmentName(EvtFilterEquipment filter) {
        String equipmentName = filter.getEquipmentName();
        equipmentName = equipmentName + "(" + filter.getIpAddress() + ")";
        return equipmentName;
    }
}

