/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.util.fault;

import com.bwanms.client.gui.fault.ColorSchema;
import com.bwanms.client.gui.fault.events.EventManagerDefaultColumns;
import com.bwanms.gui.Internationalizer;
import com.bwanms.model.fault.Event;
import com.bwanms.model.fault.constants.AlarmType;
import com.bwanms.model.fault.constants.ConfigChangeType;
import com.bwanms.model.fault.constants.EventCategory;
import com.bwanms.model.fault.constants.ProbableCause;
import com.bwanms.model.fault.constants.Severity;
import com.bwanms.model.fault.constants.StateChangeType;
import com.bwanms.model.fault.constants.SysEventType;
import com.bwanms.util.PluginUtil;
import java.awt.Color;
import java.text.SimpleDateFormat;
import java.util.Date;

public final class EventUtil {
    public static final SimpleDateFormat df = new SimpleDateFormat("HH:mm:ss yyyy-MM-dd");
    static final String NULL_STRING = "<null>";

    private EventUtil() {
    }

    public static boolean isAlarm(Event event) {
        return event.getEventCategory() == EventCategory.Alarm.byteValue();
    }

    public static boolean isStateChange(Event event) {
        return event.getEventCategory() == EventCategory.StateChange.byteValue();
    }

    public static boolean isConfigChange(Event event) {
        return event.getEventCategory() == EventCategory.ConfigChange.byteValue();
    }

    public static boolean isSysEvent(Event event) {
        return event.getEventCategory() == EventCategory.SysEvent.byteValue();
    }

    public static boolean isAckableEvent(Event event) {
        return !EventUtil.isAlarm(event) && event.isAckRequired();
    }

    public static boolean isAcked(Event event) {
        String ackedBy = event.getAckedBy();
        return ackedBy != null && ackedBy.length() > 0;
    }

    public static boolean isCleared(Event event) {
        String clearedBy = event.getClearedBy();
        return clearedBy != null && clearedBy.length() > 0;
    }

    public static boolean isClearedByCorrelation(Event event) {
        return EventUtil.isCleared(event) && "Correlation".equalsIgnoreCase(event.getClearedBy());
    }

    public static boolean isClearingEvent(Event event) {
        return EventUtil.isAlarm(event) && event.getEventSeverity() == Severity.Cleared.byteValue();
    }

    public static boolean isDeleted(Event event) {
        return event.getDeleted() == 1;
    }

    public static String translateEquipmentType(Event event, Internationalizer i18n) {
        Enum<?> neType = PluginUtil.getNEType(event.getEquipmentType());
        return neType != null ? i18n.translateString(neType.toString()) : "";
    }

    public static String translateEventSeverity(Event event, Internationalizer i18n) {
        Severity severity = Severity.fromValue(event.getEventSeverity());
        String key = severity.toString();
        return severity.equals((Object)Severity.unexpectedValue) ? "" : i18n.translateString(key);
    }

    public static String translateObjectSeverity(Event event, Internationalizer i18n) {
        Severity severity = Severity.fromValue(event.getObjectSeverity());
        String key = severity.toString();
        return severity.equals((Object)Severity.unexpectedValue) ? "" : i18n.translateString(key);
    }

    public static String translateProbableCause(Event event, Internationalizer i18n) {
        ProbableCause cause = ProbableCause.fromValue(event.getProbableCause());
        String key = cause.toString();
        return cause.equals((Object)ProbableCause.unexpectedValue) ? "" : i18n.translateString(key);
    }

    public static String translateEventCategory(Event event, Internationalizer i18n) {
        EventCategory eventCategory = EventCategory.fromValue(event.getEventCategory());
        String key = eventCategory.toString();
        return eventCategory.equals((Object)EventCategory.unexpectedValue) ? i18n.translateString(key, eventCategory.value()) : i18n.translateString(key);
    }

    public static String translateEventType(Event event, Internationalizer i18n) {
        EventCategory eventCategory = EventCategory.fromValue(event.getEventCategory());
        String key = null;
        String i18nEventType = null;
        switch (eventCategory) {
            case Alarm: {
                AlarmType alarmType = AlarmType.fromValue(event.getEventType());
                key = alarmType.toString();
                i18nEventType = alarmType.equals((Object)AlarmType.unexpectedValue) ? i18n.translateString(key, alarmType.value()) : i18n.translateString(key);
                break;
            }
            case StateChange: {
                StateChangeType stateChgType = StateChangeType.fromValue(event.getEventType());
                key = stateChgType.toString();
                i18nEventType = stateChgType.equals((Object)StateChangeType.unexpectedValue) ? i18n.translateString(key, stateChgType.value()) : i18n.translateString(key);
                break;
            }
            case SysEvent: {
                SysEventType sysEvtType = SysEventType.fromValue(event.getEventType());
                key = sysEvtType.toString();
                i18nEventType = sysEvtType.equals((Object)SysEventType.unexpectedValue) ? i18n.translateString(key, sysEvtType.value()) : i18n.translateString(key);
                break;
            }
            case ConfigChange: {
                ConfigChangeType cfgCghType = ConfigChangeType.fromValue(event.getEventType());
                key = cfgCghType.toString();
                i18nEventType = cfgCghType.equals((Object)ConfigChangeType.unexpectedValue) ? i18n.translateString(key, cfgCghType.value()) : i18n.translateString(key);
                break;
            }
            default: {
                key = "other";
            }
        }
        return i18nEventType;
    }

    public static Color getSeverityColor(Severity severity) {
        Color color = null;
        ColorSchema activeSchema = ColorSchema.getActiveSchema();
        switch (severity) {
            case Cleared: {
                color = activeSchema.cleared();
                break;
            }
            case Indeterminate: {
                color = activeSchema.indeterminate();
                break;
            }
            case Warning: {
                color = activeSchema.warning();
                break;
            }
            case Minor: {
                color = activeSchema.minor();
                break;
            }
            case Major: {
                color = activeSchema.major();
                break;
            }
            case Critical: {
                color = activeSchema.critical();
                break;
            }
            default: {
                color = activeSchema.other();
            }
        }
        return color;
    }

    public static String[] tableHeaderForExport(Internationalizer i18n) {
        String[] colNames = new String[EventManagerDefaultColumns.COLUMN_NAMES.length];
        for (int i = 0; i < colNames.length; ++i) {
            colNames[i] = i18n.translateString(EventManagerDefaultColumns.COLUMN_NAMES[i]);
        }
        return colNames;
    }

    public static String[] toStringArrayForExport(Event event, Internationalizer i18n) {
        Event.Property[] eventProps = EventManagerDefaultColumns.PROPERTIES;
        String[] eventValues = new String[eventProps.length];
        for (int i = 0; i < eventProps.length; ++i) {
            eventValues[i] = eventProps[i].exportValueToString(event, i18n);
        }
        return eventValues;
    }

    public static String formatTimestamp(long timestamp) {
        return timestamp > 0L ? df.format(new Date(timestamp)) : "";
    }

    public static String truncateString(String value) {
        if (value != null && value.length() > 0) {
            return value.substring(0, Math.min(254, value.length()));
        }
        return "";
    }

    public static String escapeString(String value) {
        return value == null || value.length() == 0 ? NULL_STRING : value;
    }

    public static String unescapeString(String value) {
        return NULL_STRING.equalsIgnoreCase(value) ? null : value;
    }
}

