/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.util.fault;

import com.bwanms.model.fault.Command;
import com.bwanms.model.fault.CommandArg;
import com.bwanms.model.fault.Event;
import com.bwanms.util.BeanUtils;

public final class CommandUtil {
    public static String formatCmdLine(Command command, Event event) {
        StringBuilder commandString = new StringBuilder();
        String path = command.getScriptPath();
        commandString.append(path);
        int lastIndex = path.length() - 1;
        if (path.lastIndexOf(47) < lastIndex && path.lastIndexOf(92) < lastIndex) {
            commandString.append("/");
        }
        commandString.append(command.getScriptName());
        commandString.append(" ");
        for (CommandArg arg : command.getCommandArg()) {
            commandString.append(arg.getArgOption());
            commandString.append(" ");
            String qualifier = arg.getTextQualifier();
            if ("'".equals(qualifier) || "\"".equals(qualifier)) {
                commandString.append(qualifier).append(CommandUtil.formatArgValue(arg, event)).append(qualifier);
            } else {
                commandString.append(CommandUtil.formatArgValue(arg, event));
            }
            commandString.append(" ");
        }
        return commandString.toString();
    }

    private static String formatArgValue(CommandArg arg, Event event) {
        if ("Constant".equalsIgnoreCase(arg.getArgType())) {
            return arg.getArgValue();
        }
        if ("EventProperty".equalsIgnoreCase(arg.getArgType())) {
            Object value = BeanUtils.getPropertyValue(event, arg.getArgValue());
            return value != null ? value.toString() : "";
        }
        return "";
    }

    public static String getArgValue(CommandArg arg) {
        if ("Constant".equalsIgnoreCase(arg.getArgType())) {
            return arg.getArgValue();
        }
        if ("EventProperty".equalsIgnoreCase(arg.getArgType())) {
            return String.format("[%s]", arg.getArgValue());
        }
        return "";
    }
}

