/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.util.concurrent;

import com.bwanms.util.ExecutorUtils;
import com.bwanms.util.concurrent.AsyncItemsProvider;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AsyncItemsExecutor {
    private static final Logger logger = Logger.getLogger(AsyncItemsExecutor.class);
    private static int THREAD_CORE_POOL_SIZE = 6;
    private static int THREAD_MAX_POOL_SIZE = 10;
    private AsyncItemsProvider<Runnable> provider;

    public AsyncItemsExecutor(AsyncItemsProvider<? extends Runnable> provider) {
        this.provider = provider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeItems() {
        ConfiguratorPoolExecutor poolExecutor = new ConfiguratorPoolExecutor();
        try {
            Runnable item;
            int totalSubmitted = 0;
            while (this.provider.hasNext() && !this.provider.shouldAbort() && (item = (Runnable)this.provider.next()) != null) {
                try {
                    poolExecutor.execute(item);
                    ++totalSubmitted;
                    logger.debug((Object)("SUBMITTED item: " + item.toString()));
                }
                catch (Throwable t) {
                    logger.debug((Object)("Error executing item: " + item.toString()));
                }
            }
            poolExecutor.finishLock.lock();
            try {
                while (poolExecutor.getTotalFinished() < totalSubmitted) {
                    try {
                        poolExecutor.noneRunning.await();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }
            finally {
                poolExecutor.finishLock.unlock();
            }
            logger.debug((Object)"==== FINISHED ALL.");
        }
        catch (Throwable t) {
            logger.error((Object)t, t);
        }
        finally {
            ExecutorUtils.shutdownAndWait("AsyncPoolExecutor", poolExecutor);
        }
    }

    private void itemBeforeExecute(Runnable item) {
        this.provider.itemStarting(item);
    }

    private void itemAfterExecute(Runnable item) {
        this.provider.itemFinished(item);
    }

    private class ConfiguratorPoolExecutor
    extends ThreadPoolExecutor {
        ReentrantLock finishLock;
        Condition noneRunning;
        private int currentRunning;
        private int totalFinished;

        public ConfiguratorPoolExecutor() {
            super(THREAD_CORE_POOL_SIZE, THREAD_MAX_POOL_SIZE, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
            this.finishLock = new ReentrantLock();
            this.noneRunning = this.finishLock.newCondition();
            this.currentRunning = 0;
            this.totalFinished = 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void beforeExecute(Thread t, Runnable r) {
            logger.debug((Object)("---- beforeExecute item: " + r.toString()));
            this.finishLock.lock();
            try {
                ++this.currentRunning;
            }
            finally {
                this.finishLock.unlock();
            }
            AsyncItemsExecutor.this.itemBeforeExecute(r);
            super.beforeExecute(t, r);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void afterExecute(Runnable r, Throwable t) {
            logger.debug((Object)("---- afterExecute item: " + r.toString()));
            super.afterExecute(r, t);
            AsyncItemsExecutor.this.itemAfterExecute(r);
            this.finishLock.lock();
            try {
                ++this.totalFinished;
                if (0 == --this.currentRunning) {
                    this.noneRunning.signal();
                }
            }
            finally {
                this.finishLock.unlock();
            }
        }

        public int getTotalFinished() {
            return this.totalFinished;
        }
    }
}

