/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.util.archive;

import com.bwanms.util.archive.spi.Decompressor;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import org.apache.log4j.Logger;

public class DefaultDecompressor
implements Decompressor {
    private static final Logger LOG = Logger.getLogger(DefaultDecompressor.class);

    public byte[] decompress(byte[] compressedData) {
        Inflater decompressor = new Inflater();
        decompressor.setInput(compressedData);
        ByteArrayOutputStream bos = new ByteArrayOutputStream(compressedData.length);
        byte[] buffer = new byte[1024];
        while (!decompressor.finished()) {
            try {
                int count = decompressor.inflate(buffer);
                bos.write(buffer, 0, count);
            }
            catch (DataFormatException ex) {
                ex.printStackTrace();
                LOG.error((Object)ex.getMessage(), (Throwable)ex);
            }
        }
        try {
            bos.close();
        }
        catch (IOException e) {
            // empty catch block
        }
        byte[] decompressedData = bos.toByteArray();
        LOG.info((Object)String.format("Counters results compressed data lenght = %d Bytes", decompressedData.length));
        return decompressedData;
    }
}

