/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.util.archive;

import com.bwanms.util.archive.spi.Compressor;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.zip.Deflater;
import org.apache.log4j.Logger;

public class DefaultCompressor
implements Compressor {
    private static final Logger LOG = Logger.getLogger(DefaultCompressor.class);

    public byte[] compress(byte[] input) {
        LOG.debug((Object)String.format("compress %d bytes", input != null ? input.length : -1));
        Deflater compressor = new Deflater();
        compressor.setInput(input);
        compressor.setLevel(9);
        compressor.finish();
        ByteArrayOutputStream bos = new ByteArrayOutputStream(input.length);
        byte[] buffer = new byte[1024];
        while (!compressor.finished()) {
            int count = compressor.deflate(buffer);
            bos.write(buffer, 0, count);
        }
        try {
            bos.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
            LOG.error((Object)ex.getMessage(), (Throwable)ex);
        }
        byte[] output = bos.toByteArray();
        LOG.debug((Object)String.format("Counters measurements collection results compressed data lenght = %d Bytes", output.length));
        return output;
    }
}

