/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.util;

import com.bwanms.util.FrameUtil;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JComponent;
import javax.swing.JFrame;

public class UserInterfaceUtil {
    public static void run(JComponent panel, int width, int height, final Runnable cleanupMethod) {
        final JFrame frame = FrameUtil.createFrame();
        frame.setTitle(panel.getClass().getName());
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                frame.dispose();
                super.windowClosing(e);
                cleanupMethod.run();
            }
        });
        frame.getContentPane().add(panel);
        int maxWidth = (int)frame.getGraphicsConfiguration().getBounds().getWidth();
        int maxHeight = (int)frame.getGraphicsConfiguration().getBounds().getHeight();
        frame.setSize(width, height);
        frame.setLocation((maxWidth - width) / 2, (maxHeight - height) / 2);
        frame.setVisible(true);
    }

    public static String escapeHTML(String string) {
        StringBuffer sb = new StringBuffer(string.length());
        boolean lastWasBlankChar = false;
        for (char c : string.toCharArray()) {
            if (c == ' ') {
                if (lastWasBlankChar) {
                    lastWasBlankChar = false;
                    sb.append("&nbsp;");
                    continue;
                }
                lastWasBlankChar = true;
                sb.append(' ');
                continue;
            }
            lastWasBlankChar = false;
            if (c == '\"') {
                sb.append("&quot;");
                continue;
            }
            if (c == '&') {
                sb.append("&amp;");
                continue;
            }
            if (c == '<') {
                sb.append("&lt;");
                continue;
            }
            if (c == '>') {
                sb.append("&gt;");
                continue;
            }
            if (c == '\n') {
                sb.append("&lt;br/&gt;");
                continue;
            }
            int ci = 0xFFFF & c;
            if (ci < 160) {
                sb.append(c);
                continue;
            }
            sb.append("&#");
            sb.append(new Integer(ci).toString());
            sb.append(';');
        }
        return sb.toString();
    }
}

