/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.util;

import com.bwanms.util.ExecutorUtils;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TimedObjectCache<K, T> {
    private static final Logger logger = Logger.getLogger(TimedObjectCache.class);
    private LinkedHashMap<K, EntryAccess> accessMap = new LinkedHashMap(16, 0.75f, true);
    private long retentionTime;
    private TimeUnit retentionTimeUnit;
    private long retentionTimeMillis;
    private String name = "TimedObjectCache";
    private ScheduledExecutorService executor;

    public TimedObjectCache(String name, long retentionTime, TimeUnit retentionTimeUnit) {
        this.retentionTime = retentionTime;
        this.retentionTimeUnit = retentionTimeUnit;
        this.retentionTimeMillis = retentionTimeUnit.toMillis(retentionTime);
        this.name = name;
        this.start();
    }

    private void start() {
        this.executor = Executors.newSingleThreadScheduledExecutor();
        this.executor.scheduleAtFixedRate(new CacheCleanupRunnable(), this.retentionTime / 2L, this.retentionTime / 2L, this.retentionTimeUnit);
    }

    public synchronized T get(Object key) {
        EntryAccess access = this.accessMap.get(key);
        if (access != null) {
            access.accessTime = System.currentTimeMillis();
            return access.value;
        }
        return null;
    }

    public synchronized T put(K key, T value) {
        EntryAccess access = new EntryAccess();
        access.key = key;
        access.value = value;
        access.accessTime = System.currentTimeMillis();
        EntryAccess prevValue = this.accessMap.put(key, access);
        return prevValue != null ? (T)prevValue.value : null;
    }

    public synchronized T remove(K key) {
        EntryAccess access = (EntryAccess)this.accessMap.remove(key);
        return access != null ? (T)access.value : null;
    }

    public boolean isRemovable(T entry) {
        return true;
    }

    public void shutdown() {
        logger.debug((Object)("[" + this.name + "] shutdown"));
        ExecutorUtils.shutdownAndWait(this.name, this.executor);
    }

    public String getName() {
        return this.name;
    }

    private class CacheCleanupRunnable
    implements Runnable {
        private CacheCleanupRunnable() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            int removedEntries = 0;
            ArrayList entries = new ArrayList();
            TimedObjectCache timedObjectCache = TimedObjectCache.this;
            synchronized (timedObjectCache) {
                entries.addAll(TimedObjectCache.this.accessMap.values());
            }
            for (EntryAccess entry : entries) {
                if (System.currentTimeMillis() - entry.accessTime < TimedObjectCache.this.retentionTimeMillis) break;
                if (!TimedObjectCache.this.isRemovable(entry.value)) continue;
                ++removedEntries;
                TimedObjectCache.this.remove(entry.key);
            }
            logger.debug((Object)("[" + TimedObjectCache.this.name + "] removed " + removedEntries + " entries"));
        }
    }

    private class EntryAccess {
        K key;
        T value;
        long accessTime;

        private EntryAccess() {
        }
    }
}

