/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.util;

import com.bwanms.gui.AbstractBindedEditorView;
import com.bwanms.gui.TaskRuntimeResultsView;
import com.bwanms.gui.taskmanager.TaskResultsView;
import com.bwanms.gui.taskmanager.xsl.XSLTransformer;
import com.bwanms.model.Equipment;
import com.bwanms.model.MultipleConfigTask;
import com.bwanms.model.Task;
import com.bwanms.model.file.BackupConfigFile;
import com.bwanms.plugin.ExtensionRegistryFactory;
import com.bwanms.plugin.IConfigurationElement;
import com.bwanms.plugin.IExtension;
import com.bwanms.plugin.IExtensionPoint;
import com.bwanms.plugin.IExtensionRegistry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskPluginUtil {
    private static Map<String, Class<? extends Task>> classesForTypeCache;
    private static Map<String, Class> editorClassesForClassCache;
    private static Map<String, Class> xslTransformersForClassCache;
    private static Map<String, Boolean> availableTaskTypes;
    private static Map<Class, String> typesForClassCache;
    private static Map<String, Class> runtimeViewerClassesForClassCache;
    private static Map<Class, String> multipleConfigEqGroups;
    private static Map<String, Class> multipleConfigTasks;
    private static HashMap<String, Class<? extends Task>> restoreTasks;
    private static HashMap<Class, String> configBackupEqGroups;
    private static HashMap<String, Class> configBackupTasks;

    private static Class classForName(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            if (className.endsWith(".NotYet")) {
                System.err.println(e.getMessage());
            } else {
                e.printStackTrace();
            }
            return null;
        }
    }

    public static Map<String, Boolean> getTaskTypes() {
        return availableTaskTypes;
    }

    public static String getTypeForClass(Class<? extends Task> clazz) {
        return typesForClassCache.get(clazz);
    }

    public static Class<? extends Task> getTaskForType(String type) {
        return classesForTypeCache.get(type);
    }

    public static AbstractBindedEditorView<Task> getViewForClass(Class clazz) {
        AbstractBindedEditorView view = null;
        Class viewClass = editorClassesForClassCache.get(clazz.getName());
        if (null != viewClass) {
            view = (AbstractBindedEditorView)TaskPluginUtil.newClassInstance(viewClass);
        }
        return view;
    }

    public static TaskResultsView getResultViewerForClass(Class clazz) {
        return new TaskResultsView();
    }

    public static XSLTransformer getXSLTransformerForClass(Class clazz) {
        XSLTransformer transformer = null;
        Class transformerClass = xslTransformersForClassCache.get(clazz.getName());
        if (null != transformerClass) {
            transformer = (XSLTransformer)TaskPluginUtil.newClassInstance(transformerClass);
        }
        return transformer;
    }

    public static TaskRuntimeResultsView getRuntimeResultsViewerForClass(Class clazz) {
        TaskRuntimeResultsView view = null;
        Class viewClass = runtimeViewerClassesForClassCache.get(clazz.getName());
        if (null != viewClass) {
            view = (TaskRuntimeResultsView)TaskPluginUtil.newClassInstance(viewClass);
        }
        return view;
    }

    private static Object newClassInstance(Class clazz) {
        try {
            return clazz.newInstance();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static MultipleConfigTask getMultipleConfigTask(Class tempcls) {
        try {
            Class taskClass;
            String group = multipleConfigEqGroups.get(tempcls);
            if (group != null && (taskClass = multipleConfigTasks.get(group)) != null) {
                return (MultipleConfigTask)taskClass.newInstance();
            }
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static String getMultipleConfigGroupForEquipment(Class<? extends Equipment> class1) {
        return multipleConfigEqGroups.get(class1);
    }

    public static <T extends Task, E extends Equipment> T getGenericCfgBkupTask(Class<E> clazz) {
        try {
            Class ctask;
            String group = configBackupEqGroups.get(clazz);
            if (group != null && (ctask = configBackupTasks.get(group)) != null) {
                return (T)((Task)ctask.newInstance());
            }
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (ClassCastException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static MultipleConfigTask getConfigBackupTask(Class tempcls) {
        Object task = TaskPluginUtil.getGenericCfgBkupTask(tempcls);
        if (task instanceof MultipleConfigTask) {
            return (MultipleConfigTask)task;
        }
        return null;
    }

    public static String getConfigBackupGroupForEquipment(Class<? extends Equipment> class1) {
        return configBackupEqGroups.get(class1);
    }

    public static Class<? extends Task> getConfigRestoreTaskForClass(Class<? extends BackupConfigFile> clazz) {
        return restoreTasks.get(clazz.getName());
    }

    public static List<Class> getTaskTypesList() {
        return new ArrayList<Class>(typesForClassCache.keySet());
    }

    static {
        Class taskClass;
        String group;
        String group2;
        Class eqClass;
        IConfigurationElement[] configElements;
        IExtension[] extensions;
        classesForTypeCache = new HashMap<String, Class<? extends Task>>();
        editorClassesForClassCache = new HashMap<String, Class>();
        xslTransformersForClassCache = new HashMap<String, Class>();
        availableTaskTypes = new HashMap<String, Boolean>();
        typesForClassCache = new HashMap<Class, String>();
        runtimeViewerClassesForClassCache = new HashMap<String, Class>();
        multipleConfigEqGroups = new HashMap<Class, String>();
        multipleConfigTasks = new HashMap<String, Class>();
        configBackupEqGroups = new HashMap();
        configBackupTasks = new HashMap();
        restoreTasks = new HashMap();
        IExtensionRegistry extensionRegistry = ExtensionRegistryFactory.getExtensionRegistry();
        IExtensionPoint extensionPoint = extensionRegistry.getExtensionPoint("com.bwanms.task");
        for (IExtension extension : extensions = extensionPoint.getExtensions()) {
            for (IConfigurationElement element : configElements = extension.getConfigurationElements()) {
                String valName = element.getAttribute("name");
                String valSystem = element.getAttribute("system");
                Class valClass = TaskPluginUtil.classForName(element.getAttribute("class"));
                Class valEditorPanel = TaskPluginUtil.classForName(element.getAttribute("editorPanel"));
                Class valViewerPanel = TaskPluginUtil.classForName(element.getAttribute("viewerPanel"));
                Class valHistoryTransformerPanel = TaskPluginUtil.classForName(element.getAttribute("historyTransformer"));
                availableTaskTypes.put(valName, !"true".equals(valSystem));
                typesForClassCache.put(valClass, valName);
                classesForTypeCache.put(valName, valClass);
                editorClassesForClassCache.put(valClass.getName(), valEditorPanel);
                xslTransformersForClassCache.put(valClass.getName(), valHistoryTransformerPanel);
                runtimeViewerClassesForClassCache.put(valClass.getName(), valViewerPanel);
            }
        }
        extensionPoint = extensionRegistry.getExtensionPoint("com.bwanms.multipleConfigurationGroups");
        for (IExtension extension : extensions = extensionPoint.getExtensions()) {
            for (IConfigurationElement element : configElements = extension.getConfigurationElements()) {
                eqClass = TaskPluginUtil.classForName(element.getAttribute("class"));
                group2 = element.getAttribute("groupName");
                multipleConfigEqGroups.put(eqClass, group2);
            }
        }
        extensionPoint = extensionRegistry.getExtensionPoint("com.bwanms.multipleConfigurationTasks");
        for (IExtension extension : extensions = extensionPoint.getExtensions()) {
            for (IConfigurationElement element : configElements = extension.getConfigurationElements()) {
                group = element.getAttribute("name");
                taskClass = TaskPluginUtil.classForName(element.getAttribute("task"));
                multipleConfigTasks.put(group, taskClass);
            }
        }
        extensionPoint = extensionRegistry.getExtensionPoint("com.bwanms.backupConfigurationGroups");
        for (IExtension extension : extensions = extensionPoint.getExtensions()) {
            for (IConfigurationElement element : configElements = extension.getConfigurationElements()) {
                eqClass = TaskPluginUtil.classForName(element.getAttribute("class"));
                group2 = element.getAttribute("groupName");
                configBackupEqGroups.put(eqClass, group2);
            }
        }
        extensionPoint = extensionRegistry.getExtensionPoint("com.bwanms.configurationBackupTasks");
        for (IExtension extension : extensions = extensionPoint.getExtensions()) {
            for (IConfigurationElement element : configElements = extension.getConfigurationElements()) {
                group = element.getAttribute("name");
                taskClass = TaskPluginUtil.classForName(element.getAttribute("task"));
                configBackupTasks.put(group, taskClass);
            }
        }
        extensionPoint = extensionRegistry.getExtensionPoint("com.bwanms.configurationRestoreTasks");
        for (IExtension extension : extensions = extensionPoint.getExtensions()) {
            for (IConfigurationElement element : configElements = extension.getConfigurationElements()) {
                String configClass = element.getAttribute("configurationClass");
                taskClass = TaskPluginUtil.classForName(element.getAttribute("taskClass"));
                restoreTasks.put(configClass, taskClass);
            }
        }
    }
}

