/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.util;

public final class SystemPropertyUtil {
    private SystemPropertyUtil() {
    }

    public static String getString(String propertyName, String defaultValue) {
        String value = null;
        try {
            value = System.getProperty(propertyName, defaultValue);
            if (value == null || "".equals(value)) {
                value = defaultValue;
            }
        }
        catch (Exception e) {
            value = defaultValue;
        }
        return value;
    }

    public static Long getLong(String propertyName, Long defaultValue) {
        Long value = null;
        try {
            String temp = System.getProperty(propertyName);
            value = temp == null || "".equals(temp) ? defaultValue : Long.decode(temp);
        }
        catch (Exception e) {
            value = defaultValue;
        }
        return value;
    }

    public static long getLong(String propertyName, long defaultValue) {
        long value = defaultValue;
        try {
            String temp = System.getProperty(propertyName);
            value = temp == null || "".equals(temp) ? defaultValue : Long.decode(temp);
        }
        catch (Exception e) {
            value = defaultValue;
        }
        return value;
    }

    public static Integer getInt(String propertyName, Integer defaultValue) {
        Integer value = null;
        try {
            String temp = System.getProperty(propertyName);
            value = temp == null || "".equals(temp) ? defaultValue : Integer.decode(temp);
        }
        catch (Exception e) {
            value = defaultValue;
        }
        return value;
    }

    public static int getInt(String propertyName, int defaultValue) {
        int value = defaultValue;
        try {
            String temp = System.getProperty(propertyName);
            value = temp == null || "".equals(temp) ? defaultValue : Integer.decode(temp);
        }
        catch (Exception e) {
            value = defaultValue;
        }
        return value;
    }

    public static Boolean getBoolean(String propertyName, String defaultValue) {
        Boolean value = null;
        try {
            String temp = System.getProperty(propertyName);
            value = temp == null || "".equals(temp) ? Boolean.valueOf(defaultValue) : Boolean.valueOf(temp);
        }
        catch (Exception e) {
            value = Boolean.FALSE;
        }
        return value;
    }

    public static boolean getBoolean(String propertyName, String truthValue, boolean defaultValue) {
        boolean value = defaultValue;
        try {
            String temp = System.getProperty(propertyName);
            value = temp == null || "".equals(temp) ? defaultValue : temp.equalsIgnoreCase(truthValue);
        }
        catch (Exception e) {
            value = false;
        }
        return value;
    }
}

