/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.util;

import com.bwanms.plugin.ExtensionRegistryFactory;
import com.bwanms.plugin.IConfigurationElement;
import com.bwanms.plugin.IExtension;
import com.bwanms.plugin.IExtensionPoint;
import com.bwanms.plugin.IExtensionRegistry;
import com.bwanms.services.SynchronizationCandidateProvider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SynchronizationCandidateProviderUtil {
    private static final String CLASS_ATTRIBUTE_NAME = "class";
    private static final String PROVIDER_TAG_NAME = "provider";
    private static final String SYNCHRONIZATION_CANDIDATE_PROVIDER_EXTENSION_NAME = "com.bwanms.synchronizationCandidateProvider";
    private static final transient Logger logger = Logger.getLogger(SynchronizationCandidateProviderUtil.class);
    private static final List<SynchronizationCandidateProvider> SYNCHRONIZATION_CANDIDATE_PROVIDERS;

    public static List<SynchronizationCandidateProvider> getProviders() {
        return SYNCHRONIZATION_CANDIDATE_PROVIDERS;
    }

    private static void createAndAddProvider(String className, List<SynchronizationCandidateProvider> providers) {
        try {
            Class<?> providerClass = Class.forName(className);
            SynchronizationCandidateProvider provider = (SynchronizationCandidateProvider)providerClass.newInstance();
            providers.add(provider);
        }
        catch (ClassNotFoundException e) {
            String msg = String.format("Could not find class identified by name [%s]!", className);
            logger.error((Object)msg, (Throwable)e);
        }
        catch (InstantiationException e) {
            String msg = String.format("Could not create instance from class name [%s]!", className);
            logger.error((Object)msg, (Throwable)e);
        }
        catch (IllegalAccessException e) {
            String msg = String.format("Could not create instance from class name [%s]!", className);
            logger.error((Object)msg, (Throwable)e);
        }
        catch (ClassCastException e) {
            String msg = String.format("Class [%s] does not implement required interface %s", className, SynchronizationCandidateProvider.class.getName());
            logger.error((Object)msg, (Throwable)e);
        }
    }

    static {
        IExtensionRegistry extensionRegistry = ExtensionRegistryFactory.getExtensionRegistry();
        IExtensionPoint extensionPoint = extensionRegistry.getExtensionPoint(SYNCHRONIZATION_CANDIDATE_PROVIDER_EXTENSION_NAME);
        ArrayList<SynchronizationCandidateProvider> providers = new ArrayList<SynchronizationCandidateProvider>();
        if (null != extensionPoint) {
            IExtension[] extensions;
            for (IExtension extension : extensions = extensionPoint.getExtensions()) {
                IConfigurationElement[] configElements = extension.getConfigurationElements();
                IConfigurationElement providerElement = configElements[0];
                if (!PROVIDER_TAG_NAME.equals(providerElement.getName())) {
                    throw new RuntimeException("Invalid configuration for extension point [com.bwanms.synchronizationCandidateProvider]! Expecting tag name [provider], found [" + providerElement.getName() + "].");
                }
                String providerClassName = providerElement.getAttribute(CLASS_ATTRIBUTE_NAME);
                SynchronizationCandidateProviderUtil.createAndAddProvider(providerClassName, providers);
            }
        }
        SYNCHRONIZATION_CANDIDATE_PROVIDERS = Collections.unmodifiableList(providers);
    }
}

