/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.util;

import com.bwanms.util.ApplicationDir;
import java.awt.Color;
import java.awt.Font;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Properties;
import javax.swing.UIManager;
import org.apache.log4j.Logger;

public class Settings {
    private static final Logger logger = Logger.getLogger(Settings.class);
    private static Settings instance = new Settings();
    private String applicationDir;
    private Properties applicationProperties = new Properties();

    public static void setLookAndFeel() {
        String platformType = System.getProperty("com.bwanms.platform", "remote");
        Settings.setLookAndFeel("local".equalsIgnoreCase(platformType) || "debug".equalsIgnoreCase(platformType));
    }

    public static void setLookAndFeel(boolean localPlatform) {
        try {
            String look = null;
            if (localPlatform) {
                look = "com.jgoodies.looks.windows.WindowsLookAndFeel";
            } else {
                look = "com.jgoodies.looks.plastic.PlasticLookAndFeel";
                Font font = new Font("Tahoma", 0, 11);
                UIManager.put("Button.font", font);
                UIManager.put("CheckBox.font", font);
                UIManager.put("ComboBox.font", font);
                UIManager.put("DesktopIcon.font", font);
                UIManager.put("EditorPane.font", font);
                UIManager.put("FormattedTextField.font", font);
                UIManager.put("InternalFrame.titleFont", font);
                UIManager.put("Label.font", font);
                UIManager.put("List.font", font);
                UIManager.put("Menu.font", font);
                UIManager.put("MenuBar.titleFont", font);
                UIManager.put("MenuItem.font", font);
                UIManager.put("OptionPane.font", font);
                UIManager.put("PasswordField.font", font);
                UIManager.put("PopupMenu.font", font);
                UIManager.put("ProgressBar.font", font);
                UIManager.put("RadioButton.font", font);
                UIManager.put("RadioButtonMenuItem.font", font);
                UIManager.put("Spinner.font", font);
                UIManager.put("TabbedPane.font", font);
                UIManager.put("Table.font", font);
                UIManager.put("TableHeader.font", font);
                UIManager.put("TextArea.font", font);
                UIManager.put("TextField.font", font);
                UIManager.put("TextPane.font", font);
                UIManager.put("ToggleButton.font", font);
                UIManager.put("ToolBar.font", font);
                UIManager.put("ToolTip.font", font);
                UIManager.put("Tree.font", font);
            }
            logger.info((Object)("lookAndFeel=[" + look + "]"));
            UIManager.setLookAndFeel(look);
            UIManager.put("Table.selectionBackground", new Color(204, 204, 255));
            UIManager.put("Table.selectionForeground", Color.BLACK);
            UIManager.put("Tree.selectionBackground", new Color(204, 204, 255));
            UIManager.put("Tree.selectionForeground", Color.BLACK);
        }
        catch (Exception e) {
            logger.error((Object)"Can't set look and feel.", (Throwable)e);
        }
    }

    public static Settings instance() {
        return instance;
    }

    public Settings() {
        this.applicationDir = this.readApplicationDir();
        this.readApplicationProperties();
    }

    public int getSNMPSettingsDefaultRetries() {
        return 2;
    }

    public long getSNMPSettingsDefaultTimeout() {
        return 3000L;
    }

    public int getSNMPSettingsDefaultPort() {
        return 161;
    }

    public long getPollingServiceReachableSynchronizationPeriod() {
        return 60000L;
    }

    public long getPollingServiceUnreachableSynchronizationPeriod() {
        return 10000L;
    }

    public int getPollingServiceMaximumThreads() {
        return 3;
    }

    public String getPluginsDir() {
        return this.getApplicationDir() + File.separator + "plugins";
    }

    public String getApplicationDir() {
        return this.applicationDir;
    }

    private String readApplicationDir() {
        return ApplicationDir.getApplicationDir();
    }

    private void readApplicationProperties() {
        try {
            File file = new File(this.getApplicationPropertiesFileName());
            if (file.exists()) {
                logger.info((Object)("LightBwanms configuration file [" + file.getAbsolutePath() + "] is used."));
                this.applicationProperties.load(new FileInputStream(file));
            } else {
                logger.warn((Object)("LightBwanms configuration file [" + file.getAbsolutePath() + "] is not found."));
            }
        }
        catch (FileNotFoundException e) {
            logger.debug((Object)"Production version.");
        }
        catch (IOException e) {
            logger.debug((Object)"Production version.");
        }
    }

    private String getApplicationPropertiesFileName() {
        return this.getApplicationDir() + File.separator + "config.properties";
    }
}

