/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.util;

import com.bwanms.gui.ExceptionUtil;
import com.bwanms.gui.Internationalizer;
import com.bwanms.gui.taskmanager.xsl.XSLTransformer;
import com.bwanms.util.FrameUtil;
import com.bwanms.util.MessageBox;
import java.awt.Window;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import org.apache.log4j.Logger;

public class ReportUtil {
    private static final Logger log = Logger.getLogger(ReportUtil.class);
    private static final Internationalizer i18n = Internationalizer.getInternationalizer(ReportUtil.class);
    public static final int MAX_SIZE = 200000;

    public static void exportToHTMLFile(String content, final XSLTransformer xslTransformer, JComponent component) {
        JFileChooser chooser = new JFileChooser();
        chooser.setFileFilter(new FileFilter(){

            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return true;
                }
                String extension = ReportUtil.getExtension(f);
                if (extension != null) {
                    return extension.equals(xslTransformer.getFileExtension());
                }
                return false;
            }

            public String getDescription() {
                return xslTransformer.getFileExtension();
            }
        });
        Window jframe = SwingUtilities.getWindowAncestor(component);
        int returnVal = chooser.showSaveDialog(jframe);
        if (returnVal == 0) {
            File file = chooser.getSelectedFile();
            if (ReportUtil.getExtension(file) == null) {
                file = new File(file.getPath() + "." + xslTransformer.getFileExtension());
            }
            if (file.exists() && !FrameUtil.showConfirmation(component, i18n.translateString("CannotSaveAsOverride"))) {
                return;
            }
            try {
                PrintWriter pw = new PrintWriter(file);
                pw.print(content);
                pw.flush();
                pw.close();
            }
            catch (FileNotFoundException e) {
                log.debug((Object)"", (Throwable)e);
                String message = ExceptionUtil.getMessage(e);
                message = message == null ? i18n.translateString("FileNotFound", file.getAbsolutePath()) : i18n.translateString("ExportError", message);
                MessageBox.Error.quickShow(jframe, message);
            }
        }
    }

    private static String getExtension(File f) {
        String ext = null;
        String s = f.getName();
        int i = s.lastIndexOf(46);
        if (i > 0 && i < s.length() - 1) {
            ext = s.substring(i + 1).toLowerCase();
        }
        return ext;
    }
}

