/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.util;

import com.dorado.common.guiutil.OWDialogUtils;
import inetsoft.report.PreviewView;
import inetsoft.report.Previewer;
import inetsoft.report.StyleSheet;
import inetsoft.report.TableLens;
import inetsoft.report.j2d.StyleBook;
import inetsoft.report.j2d.StylePrinter;
import inetsoft.report.j2d.StyleSheet2D;
import inetsoft.report.lens.swing11.JTableLens;
import java.awt.Component;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.PrinterJob;
import javax.swing.JTable;

public class PrinterUtil {
    private PageFormat pageFormat = null;
    private PrinterJob printJob = null;
    private static final int MAX_PORTRAIT_PIXELS = 450;
    PreviewView _previewer = Previewer.createPreviewer();

    public PrinterUtil() {
        this.init();
    }

    public void init() {
        this.printJob = StylePrinter.getPrinterJob();
        this.pageFormat = this.printJob.defaultPage();
    }

    public void pageFormat() {
        this.pageFormat = this.printJob.pageDialog(this.pageFormat);
    }

    public void printTable(JTable pPrintTable, String pTitle, boolean isPreview) {
        this.printTable(pPrintTable, pTitle, isPreview, true);
    }

    public void printTable(JTable pPrintTable, String pTitle, boolean isPreview, boolean useDefaultHeaders) {
        StyleSheet2D _report = null;
        try {
            _report = new StyleSheet2D();
            _report.setCurrentTableLayout(0);
            JTableLens _lens = new JTableLens(pPrintTable);
            _lens.setColAutoSize(false);
            _report.addTable((TableLens)_lens);
            int _orientation = this.chooseOrientation(pPrintTable, _lens);
            this.printReport(_report, pTitle, isPreview, useDefaultHeaders, _orientation);
        }
        catch (Exception _e) {
            OWDialogUtils.popExceptionDialog((String)"Print Error", (Throwable)_e, (boolean)true);
            return;
        }
    }

    public void printComponent(Component pComponent) {
        StyleSheet2D _report = null;
        try {
            _report = new StyleSheet2D();
            _report.addComponent(pComponent);
            this.printReport(_report, null, false, false);
        }
        catch (Exception _e) {
            OWDialogUtils.popExceptionDialog((String)"Print Error", (Throwable)_e, (boolean)true);
            return;
        }
    }

    public void printComponent(Component pComponent, String pTitle, boolean isPreview) {
        StyleSheet2D _report = null;
        try {
            _report = new StyleSheet2D();
            int resolution = this._previewer.getPageResolution();
            int newWidth = pComponent.getWidth() / resolution;
            int newHeight = pComponent.getHeight() / resolution;
            double maxWidth = this._previewer.getPageWidth() - 2.0 * _report.getMargin().left;
            double maxHeight = this._previewer.getPageHeight() - (2.0 * _report.getMargin().top + _report.getHeaderFromEdge() + _report.getFooterFromEdge());
            boolean modifyComponentSize = false;
            if (newWidth > (int)maxWidth) {
                newWidth = (int)maxWidth;
                modifyComponentSize = true;
            }
            if (newHeight > (int)maxHeight) {
                newHeight = (int)maxHeight;
                modifyComponentSize = true;
            }
            if (modifyComponentSize) {
                _report.addComponent(pComponent, (double)newWidth, (double)newHeight);
            } else {
                _report.addComponent(pComponent);
            }
            this.printReport(_report, pTitle, isPreview, true);
        }
        catch (Exception _e) {
            OWDialogUtils.popExceptionDialog((String)"Print Error", (Throwable)_e, (boolean)true);
            return;
        }
    }

    private void printReport(StyleSheet2D pReport, String pTitle, boolean isPreview, boolean useDefaultHeaders) {
        this.printReport(pReport, pTitle, isPreview, useDefaultHeaders, 1);
    }

    private void printReport(StyleSheet2D pReport, String pTitle, boolean isPreview, boolean useDefaultHeaders, int orientation) {
        block9: {
            try {
                if (useDefaultHeaders) {
                    this.setDefaultHeaders(pReport, pTitle);
                } else {
                    this.setHeaders(pReport, pTitle);
                }
                if (!isPreview) {
                    StyleBook book = new StyleBook((StyleSheet)pReport, this.pageFormat);
                    this.printJob.setPageable((Pageable)book);
                    try {
                        if (this.printJob.printDialog()) {
                            this.printJob.print();
                        }
                        break block9;
                    }
                    catch (ArithmeticException _e) {
                        _e.printStackTrace();
                    }
                    break block9;
                }
                if (orientation == 0) {
                    double _w = this._previewer.getPageWidth();
                    double _h = this._previewer.getPageHeight();
                    this._previewer.setPageWidth(_h);
                    this._previewer.setPageHeight(_w);
                }
                this._previewer.setOrientation(orientation);
                this._previewer.pack();
                this._previewer.setVisible(true);
                this._previewer.print((StyleSheet)pReport);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void setHeaders(StyleSheet2D pReport, String pTitle) throws Exception {
    }

    private void setDefaultHeaders(StyleSheet2D pReport, String pTitle) throws Exception {
        pReport.setCurrentAlignment(2);
        pReport.addHeaderText(pTitle);
        pReport.setCurrentAlignment(1);
        pReport.addFooterText("Page {P} of {N}");
        pReport.setCurrentAlignment(4);
        pReport.addFooterText("{D}{T}");
    }

    private int chooseOrientation(JTable pPrintTable, JTableLens pLens) {
        int _colcount = pLens.getColCount();
        int _width = 0;
        for (int i = 0; i < _colcount; ++i) {
            _width += pLens.getColWidth(i);
        }
        return _width > 450 ? 0 : 1;
    }
}

