/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.util;

import com.bwanms.be.Queue;
import com.bwanms.be.QueueI;
import com.bwanms.be.local.EventBatchQueue;
import com.bwanms.be.local.QueueImpl;
import com.bwanms.be.registries.QueueRegistry;
import com.bwanms.be.registries.ejb.QueueRegistryEJBImpl;
import com.bwanms.be.registries.local.QueueRegistryLocalImpl;
import com.bwanms.be.registries.local.RegistryFactoryLocalImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum PlatformConfiguration {
    STANDALONE{

        @Override
        public Class getSecurityImpl() throws Exception {
            return Class.forName("com.bwanms.security.local.SecurityLocal");
        }

        @Override
        public Class getPersistenceSessionManagerImpl() throws Exception {
            return Class.forName("com.bwanms.persistence.SimpleSessionManager");
        }

        @Override
        public Class getServiceRegistryImpl() throws Exception {
            return Class.forName("com.bwanms.services.local.ServiceRegistryLocalImpl");
        }

        @Override
        public Class getDDRegistryFactoryImpl() throws Exception {
            return Class.forName("com.bwanms.ddi.local.DDRegistryFactoryLocalImpl");
        }

        @Override
        public Class getLegacySupportInterceptorFactory() throws Exception {
            return Class.forName("com.bwanms.legacy.LocalLegacySupportInterceptorFactory");
        }

        @Override
        public Class getMediationServiceRegistryImpl() throws Exception {
            return Class.forName("com.bwanms.mediation.local.MediationServiceRegistryLocalImpl");
        }

        @Override
        public Class getExtensionRegistryFactoryImpl() throws Exception {
            return Class.forName("com.bwanms.plugin.local.ExtensionRegistryFactoryLocalImpl");
        }

        @Override
        public Class getPlatformFactoryImpl() throws Exception {
            return Class.forName("com.bwanms.platform.local.LocalPlatformFactory");
        }

        @Override
        public Class getSessionFactoryHelperImpl() throws Exception {
            return Class.forName("com.bwanms.persistence.LocalSessionFactoryHelper");
        }

        @Override
        public Class getServiceTransactionManagementInterceptorImpl() throws Exception {
            return Class.forName("com.bwanms.persistence.local.ServiceTransactionManagementInterceptorLocal");
        }

        @Override
        public Class getEntityEventNotificationEngineImpl() throws Exception {
            return null;
        }

        @Override
        public Class getRegistryFactoryImpl() throws Exception {
            return RegistryFactoryLocalImpl.class;
        }

        @Override
        public Class getHelpUtilImpl() throws Exception {
            return Class.forName("com.bwanms.gui.help.local.HelpUtilLocal");
        }

        @Override
        public Queue getQueueImpl() throws Exception {
            return new EventBatchQueue();
        }

        @Override
        public <E> QueueI<E> getNewQueue(Class<E> clazz) throws Exception {
            return new QueueImpl();
        }

        @Override
        public QueueRegistry getQueueRegistry() throws Exception {
            return new QueueRegistryLocalImpl();
        }

        @Override
        public Class getConfigurationHelperImpl() throws Exception {
            if (1.isDebugPlatform()) {
                return Class.forName("com.bwanms.domain.logic.ejb.ConfigurationHelperEJB");
            }
            return Class.forName("com.bwanms.domain.logic.local.ConfigurationHelperLocal");
        }
    }
    ,
    JBOSS{

        @Override
        public Class getSecurityImpl() throws Exception {
            return Class.forName("com.bwanms.security.impl.SecurityImpl");
        }

        @Override
        public Class getPersistenceSessionManagerImpl() throws Exception {
            return Class.forName("com.bwanms.persistence.JbossHibernateSessionManager");
        }

        @Override
        public Class getServiceRegistryImpl() throws Exception {
            return Class.forName("com.bwanms.services.ejb.ServiceRegistryEJBImpl");
        }

        @Override
        public Class getDDRegistryFactoryImpl() throws Exception {
            return Class.forName("com.bwanms.ddi.ejb.DDRegistryFactoryEJBImpl");
        }

        @Override
        public Class getLegacySupportInterceptorFactory() throws Exception {
            return Class.forName("com.bwanms.legacy.JBossLegacySupportInterceptorFactory");
        }

        @Override
        public Class getMediationServiceRegistryImpl() throws Exception {
            return Class.forName("com.bwanms.mediation.ejb.MediationServiceRegistryEJBImpl");
        }

        @Override
        public Class getExtensionRegistryFactoryImpl() throws Exception {
            return Class.forName("com.bwanms.plugin.ejb.ExtensionRegistryFactoryEJBImpl");
        }

        @Override
        public Class getPlatformFactoryImpl() throws Exception {
            return Class.forName("com.bwanms.platform.jboss.JBossPlatformFactory");
        }

        @Override
        public Class getSessionFactoryHelperImpl() throws Exception {
            return Class.forName("com.bwanms.persistence.JBossSessionFactoryHelper");
        }

        @Override
        public Class getServiceTransactionManagementInterceptorImpl() throws Exception {
            return Class.forName("com.bwanms.persistence.jboss.ServiceTransactionManagementInterceptorJBoss");
        }

        @Override
        public Class getEntityEventNotificationEngineImpl() throws Exception {
            return Boolean.getBoolean("com.bwanms.nullNotificationEngine") ? null : Class.forName("com.bwanms.legacy.AssureNotificationEngine");
        }

        @Override
        public Class getRegistryFactoryImpl() throws Exception {
            return Class.forName("com.bwanms.be.registries.local.RegistryFactoryLocalImpl");
        }

        @Override
        public Class getHelpUtilImpl() throws Exception {
            return Class.forName("com.bwanms.gui.help.rc.HelpUtilRC");
        }

        @Override
        public Class getConfigurationHelperImpl() throws Exception {
            return Class.forName("com.bwanms.domain.logic.ejb.ConfigurationHelperEJB");
        }

        @Override
        public Queue getQueueImpl() throws Exception {
            return new EventBatchQueue();
        }

        @Override
        public <E> QueueI<E> getNewQueue(Class<E> clazz) throws Exception {
            return new QueueImpl();
        }

        @Override
        public QueueRegistry getQueueRegistry() throws Exception {
            return new QueueRegistryEJBImpl();
        }
    };

    public static final String PLATFORM_REMOTE = "remote";
    public static final String PLATFORM_LOCAL = "local";
    public static final String PLATFORM_DEBUG = "debug";

    public abstract Class getPersistenceSessionManagerImpl() throws Exception;

    public abstract Class getServiceRegistryImpl() throws Exception;

    public abstract Class getDDRegistryFactoryImpl() throws Exception;

    public abstract Class getLegacySupportInterceptorFactory() throws Exception;

    public abstract Class getMediationServiceRegistryImpl() throws Exception;

    public abstract Class getExtensionRegistryFactoryImpl() throws Exception;

    public abstract Class getSecurityImpl() throws Exception;

    public abstract Class getPlatformFactoryImpl() throws Exception;

    public abstract Class getSessionFactoryHelperImpl() throws Exception;

    public abstract Class getServiceTransactionManagementInterceptorImpl() throws Exception;

    public abstract Class getEntityEventNotificationEngineImpl() throws Exception;

    public abstract Class getHelpUtilImpl() throws Exception;

    public abstract Class getConfigurationHelperImpl() throws Exception;

    public abstract Class getRegistryFactoryImpl() throws Exception;

    public abstract Queue getQueueImpl() throws Exception;

    public abstract <E> QueueI<E> getNewQueue(Class<E> var1) throws Exception;

    public abstract QueueRegistry getQueueRegistry() throws Exception;

    public static PlatformConfiguration instance() {
        String platformType = System.getProperty("com.bwanms.platform", PLATFORM_REMOTE);
        if (PLATFORM_LOCAL.equalsIgnoreCase(platformType) || PLATFORM_DEBUG.equalsIgnoreCase(platformType)) {
            return STANDALONE;
        }
        if (PLATFORM_REMOTE.equalsIgnoreCase(platformType)) {
            return JBOSS;
        }
        throw new RuntimeException("Can't determine platform type");
    }

    public static boolean isLocalPlatform() {
        return PLATFORM_LOCAL.equals(System.getProperty("com.bwanms.platform", PLATFORM_REMOTE));
    }

    public static boolean isDebugPlatform() {
        return PLATFORM_DEBUG.equals(System.getProperty("com.bwanms.platform", PLATFORM_REMOTE));
    }

    public static boolean isRemotePlatform() {
        return PLATFORM_REMOTE.equals(System.getProperty("com.bwanms.platform", PLATFORM_REMOTE));
    }
}

