/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.util;

public class OctetString {
    public static int[] fromOctetString(String stringForm) {
        if (stringForm == null) {
            return null;
        }
        if ("".equals(stringForm)) {
            return new int[0];
        }
        String[] parts = stringForm.split(":");
        int[] ret = new int[parts.length];
        for (int i = 0; i < parts.length; ++i) {
            ret[i] = Integer.parseInt(parts[i], 16);
        }
        return ret;
    }

    private static int byteToInt(byte b) {
        if (b < 0) {
            return b & 0xFF | 0x80;
        }
        return b;
    }

    public static String toOctetString(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        StringBuilder ret = new StringBuilder();
        for (int i = 0; i < bytes.length; ++i) {
            int _byte = OctetString.byteToInt(bytes[i]);
            String hex = Integer.toHexString(_byte);
            if (hex.length() < 2) {
                ret.append("0");
            }
            ret.append(hex);
            ret.append(":");
        }
        return ret.length() == 0 ? ret.toString() : ret.substring(0, ret.length() - 1);
    }

    public static String toOctetString(int[] bytes) {
        if (bytes == null) {
            return null;
        }
        StringBuilder ret = new StringBuilder();
        for (int i = 0; i < bytes.length; ++i) {
            if (bytes[i] > 255 || bytes[i] < 0) {
                throw new NumberFormatException("invalid byte value: " + bytes[i]);
            }
            String hex = Integer.toHexString(bytes[i]);
            if (hex.length() < 2) {
                ret.append("0");
            }
            ret.append(hex);
            ret.append(":");
        }
        return ret.length() == 0 ? ret.toString() : ret.substring(0, ret.length() - 1);
    }

    public static String toDottedDecimalForm(String stringForm) {
        if (stringForm == null) {
            return null;
        }
        int[] bytes = OctetString.fromOctetString(stringForm);
        StringBuilder ret = new StringBuilder();
        for (int i = 0; i < bytes.length; ++i) {
            ret.append(Integer.toString(bytes[i]));
            ret.append(".");
        }
        return ret.length() == 0 ? ret.toString() : ret.substring(0, ret.length() - 1);
    }

    public static String fromDottedDecimalForm(String dottedForm) {
        if (dottedForm == null) {
            return null;
        }
        if ("".equals(dottedForm)) {
            return "";
        }
        String[] parts = dottedForm.split("\\.");
        StringBuilder ret = new StringBuilder();
        for (int i = 0; i < parts.length; ++i) {
            int octet = Integer.parseInt(parts[i]);
            if (octet > 255 || octet < 0) {
                throw new RangeNumberFormatException("invalid byte value: " + octet, 0, 255);
            }
            String hex = Integer.toHexString(octet);
            if (hex.length() < 2) {
                ret.append("0");
            }
            ret.append(hex);
            ret.append(":");
        }
        return ret.length() == 0 ? ret.toString() : ret.substring(0, ret.length() - 1);
    }

    public static String toDisplayString(String stringForm) {
        if (stringForm == null) {
            return null;
        }
        if ("".equals(stringForm)) {
            return "";
        }
        String[] parts = stringForm.split(":");
        char[] ret = new char[parts.length];
        for (int i = 0; i < parts.length; ++i) {
            ret[i] = (char)Integer.parseInt(parts[i], 16);
        }
        return new String(ret);
    }

    public static String fromDisplayString(String displayString) {
        if (displayString == null) {
            return null;
        }
        return OctetString.toOctetString(displayString.getBytes());
    }

    public static class RangeNumberFormatException
    extends NumberFormatException {
        public int rangeStart;
        public int rangeEnd;

        public RangeNumberFormatException(String mess, int rS, int rE) {
            super(mess);
            this.rangeStart = rS;
            this.rangeEnd = rE;
        }
    }
}

