/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.util;

import com.bwanms.gui.Internationalizer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import org.jdesktop.swingx.JXErrorPane;
import org.jdesktop.swingx.error.ErrorInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum MessageBox {
    Error{

        protected void init() {
            this.title = this.i18n.translateString("titleError");
            this.options = new String[]{this.i18n.translateString("btnOK")};
            this.optionType = -1;
            this.messageType = 0;
        }
    }
    ,
    Alert{

        protected void init() {
            this.title = this.i18n.translateString("titleAlert");
            this.options = new String[]{this.i18n.translateString("btnOK")};
            this.optionType = -1;
            this.messageType = 2;
        }
    }
    ,
    Info{

        protected void init() {
            this.title = this.i18n.translateString("titleInformation");
            this.options = new String[]{this.i18n.translateString("btnOK")};
            this.optionType = -1;
            this.messageType = 1;
        }
    }
    ,
    Confirm{

        protected void init() {
            this.title = this.i18n.translateString("titleConfirmation");
            this.message = this.i18n.translateString("messageConfirmation");
            this.options = new String[]{this.i18n.translateString("btnOK"), this.i18n.translateString("btnCANCEL")};
            this.optionType = 2;
            this.messageType = 3;
        }

        public boolean result(int option) {
            return option == 0;
        }
    }
    ,
    Confirm2{

        protected void init() {
            this.title = this.i18n.translateString("titleConfirmation");
            this.message = this.i18n.translateString("messageConfirmation");
            this.options = new String[]{this.i18n.translateString("btnYES"), this.i18n.translateString("btnNO")};
            this.optionType = 0;
            this.messageType = 3;
        }

        public boolean result(int option) {
            return option == 0;
        }
    }
    ,
    WarnConfirm{

        protected void init() {
            this.title = this.i18n.translateString("titleWarningConfirmation");
            this.message = this.i18n.translateString("messageWarningConfirmation");
            this.options = new String[]{this.i18n.translateString("btnOK"), this.i18n.translateString("btnCANCEL")};
            this.optionType = 2;
            this.messageType = 2;
        }

        public boolean result(int option) {
            return option == 0;
        }
    }
    ,
    WarnConfirm2{

        protected void init() {
            this.title = this.i18n.translateString("titleWarningConfirmation");
            this.message = this.i18n.translateString("messageWarningConfirmation");
            this.options = new String[]{this.i18n.translateString("btnYES"), this.i18n.translateString("btnNO")};
            this.optionType = 0;
            this.messageType = 2;
        }

        public boolean result(int option) {
            return option == 0;
        }
    }
    ,
    AbortRetry{

        protected void init() {
            this.title = this.i18n.translateString("titleError");
            this.options = new String[]{this.i18n.translateString("btnABORT"), this.i18n.translateString("btnRETRY"), this.i18n.translateString("btnIGNORE")};
            this.optionType = 1;
            this.messageType = 0;
        }

        public boolean result(int option) {
            return option == 0;
        }
    }
    ,
    ConfirmWithCancel{

        protected void init() {
            this.title = this.i18n.translateString("titleConfirmation");
            this.message = this.i18n.translateString("messageConfirmation");
            this.options = new String[]{this.i18n.translateString("btnYES"), this.i18n.translateString("btnNO"), this.i18n.translateString("btnCANCEL")};
            this.optionType = 1;
            this.messageType = 3;
        }

        public boolean result(int option) {
            return false;
        }
    }
    ,
    DiscardChanges{

        protected void init() {
            this.title = this.i18n.translateString("titleUnsavedChanges");
            this.message = this.i18n.translateString("messageUnsavedChanges");
            this.options = new String[]{this.i18n.translateString("btnDiscardChanges"), this.i18n.translateString("btnKeepEditing")};
            this.optionType = -1;
            this.messageType = 3;
        }

        public boolean result(int option) {
            return option == 0;
        }
    };

    protected final Internationalizer i18n = Internationalizer.getInternationalizer(MessageBox.class);
    protected String title = this.i18n.translateString("titleDefault");
    protected String message = null;
    protected int optionType = -1;
    protected int messageType = -1;
    String[] options = new String[]{this.i18n.translateString("btnCLOSE")};
    private static final int MAX_LINES = 5;
    private static final int MAX_CHARS = 50;
    private static final int MAX_WIDTH = 300;

    private MessageBox() {
        this.init();
    }

    protected abstract void init();

    public boolean result(int option) {
        return true;
    }

    public int showOptionEquipmentError(Component parent, String message) {
        if (message == null || message.length() == 0) {
            message = this.message;
        }
        if (null != parent && parent.isShowing()) {
            return MessageBox.show(parent, message, this.title, this.optionType, this.messageType, this.options);
        }
        return -1;
    }

    public int showOption(Component parent, String message, String title) {
        if (title == null || title.length() == 0) {
            title = this.title;
        }
        if (message == null || message.length() == 0) {
            message = this.message;
        }
        return MessageBox.show(parent, message, title, this.optionType, this.messageType, this.options);
    }

    public int showOption(Component parent, String message) {
        return this.showOption(parent, message, this.title);
    }

    public boolean showResult(Component parent, String message, String title) {
        return this.result(this.showOption(parent, message, title));
    }

    public boolean showResult(Component parent, String message) {
        return this.showResult(parent, message, this.title);
    }

    public void quickShow(Component parent, String message) {
        this.showOption(parent, message, this.title);
    }

    public void quickShow(String message) {
        this.showOption(null, message, this.title);
    }

    public void quickShowNotModal(JComponent component, String message) {
        JDialog dialog = this.create(component, message);
        dialog.setModal(false);
        dialog.setVisible(true);
    }

    public JDialog create(Component parent, String message, String title) {
        if (title == null || title.length() == 0) {
            title = this.title;
        }
        if (message == null || message.length() == 0) {
            message = this.message;
        }
        return MessageBox.create(parent, message, title, this.optionType, this.messageType, this.options);
    }

    public JDialog create(Component parent, String message) {
        return this.create(parent, message, this.title);
    }

    public static int show(Component parent, String message, String title, int optionType, int messageType, Object[] options) {
        return JOptionPane.showOptionDialog(parent, MessageBox.createPane(message), title, optionType, messageType, null, options, options[0]);
    }

    public static JDialog create(Component parent, String message, String title, int optionType, int messageType, Object[] options) {
        JOptionPane optionPane = new JOptionPane(MessageBox.createPane(message), messageType, optionType);
        return optionPane.createDialog(parent, title);
    }

    private static Object createPane(String message) {
        String[] lines = message.split("\n");
        int idx = 0;
        for (int i = 1; i < lines.length; ++i) {
            if (lines[i].length() <= lines[idx].length()) continue;
            idx = 1;
        }
        if (lines.length <= 5 && lines[idx].length() <= 50) {
            return message;
        }
        JTextArea jta = new JTextArea();
        jta.setBorder(null);
        jta.setEditable(false);
        jta.setWrapStyleWord(true);
        jta.setLineWrap(true);
        jta.setText(message);
        jta.setOpaque(false);
        JScrollPane jsp = new JScrollPane(jta);
        FontMetrics fm = jta.getFontMetrics((Font)UIManager.get("TextArea.font"));
        int maxLineWidth = fm.stringWidth(lines[idx]);
        int width = Math.min(maxLineWidth, 300);
        int maxWrappedLines = 0;
        if (width == 300) {
            for (String line : lines) {
                int wrappedLines = 1;
                int lineWidth = fm.stringWidth(line);
                if (lineWidth > 300) {
                    wrappedLines = (int)((double)fm.stringWidth(line) / 300.0) + 1;
                }
                maxWrappedLines += wrappedLines;
            }
            ++maxWrappedLines;
        }
        int height = fm.getHeight() * Math.min(maxWrappedLines, 5);
        jsp.setPreferredSize(new Dimension(width, height));
        jsp.setBorder(null);
        jta.setSelectionStart(0);
        jta.setSelectionEnd(0);
        return jsp;
    }

    public static void details(Component parent, String title, String shortMessage, String detailedMessage) {
        JXErrorPane.showDialog((Component)parent, (ErrorInfo)new ErrorInfo(title, shortMessage, detailedMessage, null, null, null, null));
    }

    public static int showTimeoutDialog(Component parentComponent, String message, String title, int optionType, int messageType, Object[] options, final Object initialValue, final int presetSeconds, boolean messageInScrollPane) {
        JPanel panel = new JPanel(new BorderLayout());
        JTextArea jta = new JTextArea();
        jta.setBorder(null);
        jta.setEditable(false);
        jta.setWrapStyleWord(true);
        jta.setLineWrap(true);
        jta.setText(message);
        jta.setOpaque(false);
        JComponent messageComponent = null;
        if (messageInScrollPane) {
            JScrollPane jsp = new JScrollPane(jta);
            jsp.setPreferredSize(new Dimension(250, 50));
            jsp.setBorder(null);
            messageComponent = jsp;
        } else {
            messageComponent = jta;
        }
        jta.setSelectionStart(0);
        jta.setSelectionEnd(0);
        final JLabel countDownLabel = new JLabel();
        panel.add((Component)messageComponent, "Center");
        panel.add((Component)countDownLabel, "South");
        JOptionPane pane = new JOptionPane(panel, messageType, optionType, null, options, initialValue);
        pane.setInitialValue(initialValue);
        final JDialog dialog = pane.createDialog(parentComponent, title);
        final String secondsBefore = Internationalizer.getInternationalizer(MessageBox.class).translateString("SecondsBeforeAuto");
        pane.selectInitialValue();
        new Thread(){

            public void run() {
                try {
                    for (int i = presetSeconds; i >= 0; --i) {
                        Thread.sleep(1000L);
                        if (!dialog.isVisible() || i >= 300) continue;
                        countDownLabel.setText(i + " " + secondsBefore + " \"" + initialValue + "\"");
                        dialog.pack();
                    }
                    if (dialog.isVisible()) {
                        dialog.setVisible(false);
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }.start();
        dialog.setVisible(true);
        dialog.dispose();
        Object selectedValue = pane.getValue();
        if (selectedValue == null) {
            return -1;
        }
        if (options == null) {
            if (selectedValue instanceof Integer) {
                return (Integer)selectedValue;
            }
            return -1;
        }
        int maxCounter = options.length;
        for (int counter = 0; counter < maxCounter; ++counter) {
            if (!options[counter].equals(selectedValue)) continue;
            return counter;
        }
        return -1;
    }
}

