/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.util;

public class MacAddress
implements Comparable {
    private long macAddress;

    private MacAddress(long macAddress) {
        this.macAddress = macAddress;
    }

    private static long parse(String macAddressStr) {
        return Long.parseLong(macAddressStr, 16);
    }

    public static MacAddress fromString(String stringForm) {
        return MacAddress.fromDashedString(stringForm);
    }

    public static MacAddress fromDashedString(String stringForm) {
        return MacAddress.fromDelimitedString(stringForm, '-');
    }

    public static MacAddress fromSimpleString(String stringForm) {
        return MacAddress.fromDelimitedString(stringForm, ' ');
    }

    public static MacAddress fromOctetString(String stringForm) {
        return MacAddress.fromDelimitedString(stringForm, ':');
    }

    public String toDashedString() {
        return this.toDelimitedString("-");
    }

    public String toOctetString() {
        return this.toDelimitedString(":");
    }

    public String toSimpleString() {
        return this.toDelimitedString(" ");
    }

    public String toString() {
        return this.toDashedString();
    }

    public String toInstanceString() {
        StringBuffer ret = new StringBuffer();
        for (int i = 5; i >= 0; --i) {
            long mask = 255L << i * 8;
            String octet = Long.toString((this.macAddress & mask) >> i * 8);
            ret.append(octet.toUpperCase());
            ret.append(".");
        }
        ret.setLength(ret.length() - 1);
        return ret.toString();
    }

    public static MacAddress fromInstanceString(String instanceString) {
        long address = 0L;
        String[] parts = instanceString.split("\\.");
        for (int i = 5; i >= 0; --i) {
            address += Long.parseLong(parts[5 - i]) << i * 8;
        }
        return new MacAddress(address);
    }

    private String toDelimitedString(String delimiter) {
        StringBuffer ret = new StringBuffer();
        for (int i = 5; i >= 0; --i) {
            long value = this.macAddress >> i * 8 & 0xFFL;
            if (value <= 15L) {
                ret.append('0');
            }
            ret.append(Long.toHexString(value).toUpperCase());
            ret.append(delimiter);
        }
        ret.setLength(ret.length() - 1);
        return ret.toString();
    }

    private static MacAddress fromDelimitedString(String stringForm, char delimiter) {
        StringBuffer hex = new StringBuffer();
        for (int i = 0; i < stringForm.length(); ++i) {
            if (stringForm.charAt(i) == delimiter) continue;
            hex.append(stringForm.charAt(i));
        }
        return new MacAddress(MacAddress.parse(hex.toString()));
    }

    public String toHexString() {
        return Long.toHexString(this.macAddress);
    }

    public static MacAddress fromHexString(String hexString) {
        return new MacAddress(MacAddress.parse(hexString));
    }

    public MacAddress nextMacAddress() {
        return new MacAddress(this.macAddress + 1L);
    }

    public MacAddress prevMacAddress() {
        return new MacAddress(this.macAddress - 1L);
    }

    public boolean equals(Object o) {
        return this.macAddress == ((MacAddress)o).macAddress;
    }

    public int compareTo(Object target) {
        MacAddress m = (MacAddress)target;
        if (this.macAddress < m.macAddress) {
            return -1;
        }
        if (this.macAddress > m.macAddress) {
            return 1;
        }
        return 0;
    }
}

