/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.util;

import com.bwanms.model.Equipment;
import com.bwanms.plugin.ExtensionRegistryFactory;
import com.bwanms.plugin.IConfigurationElement;
import com.bwanms.plugin.IExtensionPoint;
import com.bwanms.plugin.IExtensionRegistry;
import com.bwanms.util.legacylancher.DefaultLegacyEquipmentLauncherProperties;
import com.bwanms.util.legacylancher.ILegacyEquipmentLauncherProperties;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LegacyEquipmentLauncherPluginUtil {
    private static HashMap<String, ILegacyEquipmentLauncherProperties> launcherPropertiesMap = new HashMap();

    public static HashMap<String, Object> getLauncherProperties(Equipment equipment) {
        String className = equipment.getClass().getName();
        ILegacyEquipmentLauncherProperties legacyEquipmentLauncherProperties = launcherPropertiesMap.get(className);
        if (legacyEquipmentLauncherProperties == null) {
            IConfigurationElement[] elements;
            IExtensionRegistry extensionRegistry = ExtensionRegistryFactory.getExtensionRegistry();
            IExtensionPoint extensionPoint = extensionRegistry.getExtensionPoint("com.bwanms.legacyEquipmentLauncher");
            for (IConfigurationElement element : elements = extensionPoint.getConfigurationElements()) {
                String targetClass = element.getAttribute("targetClass");
                if (!targetClass.equals(className)) continue;
                legacyEquipmentLauncherProperties = (ILegacyEquipmentLauncherProperties)element.createExecutableExtension("class");
                break;
            }
            if (legacyEquipmentLauncherProperties == null) {
                legacyEquipmentLauncherProperties = new DefaultLegacyEquipmentLauncherProperties();
            }
            launcherPropertiesMap.put(className, legacyEquipmentLauncherProperties);
        }
        return legacyEquipmentLauncherProperties.getEquipmentProperties(equipment);
    }
}

