/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.util;

import com.bwanms.util.IpAddress;
import java.io.Serializable;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IpAddressRange
implements Serializable {
    private long start;
    private long end;

    public IpAddressRange(IpAddress start, IpAddress end) {
        this.start = start.ipAddress;
        this.end = end.ipAddress;
    }

    private IpAddressRange(long start, long end) {
        this.start = start;
        this.end = end;
    }

    public static IpAddressRange fromSubnet(IpAddress net, IpAddress mask) {
        return new IpAddressRange(IpAddressRange.getSubnetStart(net, mask), IpAddressRange.getSubnetEnd(net, mask));
    }

    public Iterator<IpAddress> getIterator() {
        return new Iterator<IpAddress>(){
            private long current;
            {
                this.current = IpAddressRange.this.start;
            }

            @Override
            public boolean hasNext() {
                return this.current <= IpAddressRange.this.end;
            }

            @Override
            public IpAddress next() {
                return new IpAddress(this.current++);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public boolean contains(IpAddress target) {
        return target.ipAddress >= this.start && target.ipAddress <= this.end;
    }

    public IpAddressRange intersect(IpAddressRange target) {
        if (this.end < target.start || target.end < this.start) {
            return null;
        }
        return new IpAddressRange(Math.max(this.start, target.start), Math.min(this.end, target.end));
    }

    public static IpAddress getSubnetStart(IpAddress net, IpAddress mask) {
        return new IpAddress(net.ipAddress & mask.ipAddress).nextIpAddress();
    }

    public static IpAddress getSubnetEnd(IpAddress net, IpAddress mask) {
        return new IpAddress(net.ipAddress | 0xFFFFFFFFL & (mask.ipAddress ^ 0xFFFFFFFFFFFFFFFFL)).prevIpAddress();
    }

    public static IpAddress getSubnetBroadcastAddress(IpAddress net, IpAddress mask) {
        return new IpAddress(net.ipAddress | 0xFFFFFFFFL & (mask.ipAddress ^ 0xFFFFFFFFFFFFFFFFL));
    }

    public int size() {
        return new Long(this.end - this.start + 1L).intValue();
    }
}

