/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.util;

import com.bwanms.util.InvalidNetworkMaskException;
import java.io.Serializable;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IpAddress
implements Serializable,
Comparable<IpAddress> {
    long ipAddress;

    public IpAddress(String ipAddressStr) {
        this.ipAddress = IpAddress.parse(ipAddressStr);
    }

    public IpAddress(long ipAddress) {
        this.ipAddress = ipAddress;
    }

    public static long parse(String ipAddressStr) {
        long ret = 0L;
        StringTokenizer tokenizer = new StringTokenizer(ipAddressStr, ".");
        if (4 != tokenizer.countTokens()) {
            throw new IllegalArgumentException("Invalid number of tokens");
        }
        for (int i = 3; i >= 0; --i) {
            long octet = Long.parseLong(tokenizer.nextToken());
            if (octet < 0L || octet > 255L) {
                throw new IllegalArgumentException("Invalid token: " + octet);
            }
            ret |= octet << i * 8;
        }
        return ret;
    }

    public String toString() {
        StringBuffer ret = new StringBuffer();
        for (int i = 3; i >= 0; --i) {
            long mask = 255L << i * 8;
            String octet = Long.toString((this.ipAddress & mask) >> i * 8);
            ret.append(octet.toUpperCase());
            ret.append(".");
        }
        ret.setLength(ret.length() - 1);
        return ret.toString();
    }

    public IpAddress nextIpAddress() {
        return new IpAddress(this.ipAddress + 1L);
    }

    public IpAddress prevIpAddress() {
        return new IpAddress(this.ipAddress - 1L);
    }

    public boolean equals(Object o) {
        return this.ipAddress == ((IpAddress)o).ipAddress;
    }

    @Override
    public int compareTo(IpAddress target) {
        IpAddress m = target;
        if (this.ipAddress < m.ipAddress) {
            return -1;
        }
        if (this.ipAddress > m.ipAddress) {
            return 1;
        }
        return 0;
    }

    public IpAddressType getIpAddressType(String netMask) throws InvalidNetworkMaskException {
        if (netMask.equals("255.255.255.255")) {
            return IpAddressType.HOST;
        }
        String binMask = Long.toBinaryString(new IpAddress(netMask).getIpAddress());
        if (binMask.contains("01")) {
            throw new InvalidNetworkMaskException(netMask);
        }
        int hostStartIdx = binMask.indexOf("0");
        if (hostStartIdx == -1) {
            System.out.println("********************************************************************");
            System.out.println("*** There is a bug in com.bwanms.util.IpAddress.getIpAddressType ***");
            System.out.println("****** The host start index should be positive. Please fix me ******");
            System.out.println("********************************************************************");
        }
        int hostLength = binMask.length() - hostStartIdx;
        String ip = Long.toBinaryString(this.getIpAddress());
        if (ip.indexOf("1", ip.length() - hostLength) == -1) {
            return IpAddressType.SUBNET;
        }
        if (ip.indexOf("0", ip.length() - hostLength) == -1) {
            return IpAddressType.BROADCAST;
        }
        return IpAddressType.HOST;
    }

    public long getIpAddress() {
        return this.ipAddress;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum IpAddressType {
        HOST,
        SUBNET,
        BROADCAST;

    }
}

