/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.util;

import com.bwanms.gui.Internationalizer;
import com.bwanms.plugin.IPluginDefinition;
import com.bwanms.plugin.impl.PluginDefinition;
import com.bwanms.services.ServerUtilService;
import com.bwanms.services.ServiceRegistry;
import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstallInfoUtil {
    public static final String OWARE_USER_ROOT = System.getenv("OWARE_USER_ROOT") == null ? "" : System.getenv("OWARE_USER_ROOT");
    public static final String PATH_OWAREAPPS = OWARE_USER_ROOT + "/" + "owareapps";
    private static final String FILE_OWAREAPPS_PROJECT_PROPERTIES = PATH_OWAREAPPS + "/%s/src/project.properties";
    public static final String PROPERTY_IS_BWANMS_PROJECT = "project.isBwanmsProject";
    public static final String PROPERTY_PROJECT_VERSION_MAJOR = "project.version.major";
    public static final String PROPERTY_PROJECT_VERSION_MINOR = "project.version.minor";
    public static final String PROPERTY_PROJECT_VERSION_MAINT = "project.version.maint";
    public static final String PROPERTY_PROJECT_VERSION_BUILD = "project.version.build";
    public static final String PROPERTY_IS_BWANMS_DRIVER = "project.isBwanmsDriver";
    public static final String PROPERTY_VALUE_TRUE = "true";
    public static final String PROPERTY_PROJECT_PLUGIN_MODULE = "project.oware.moduleName";
    public static final String PROPERTY_PROJECT_PLUGIN_ID = "project.plugin.name";
    public static final String PROPERTY_PROJECT_PLUGIN_INFO = "project.info";
    public static final String PROPERTY_PROJECT_PLUGIN_NAME = "project.plugin.description";
    public static final String PLUGIN_MODULE_INFR = "ngnms";
    private static IPluginDefinition serverInfrInfo;
    private static IPluginDefinition clientInfrInfo;
    private static List<IPluginDefinition> serverDDInfoList;
    private static List<IPluginDefinition> clientDDInfoList;
    private static final Comparator<IPluginDefinition> comparator;

    public static final IPluginDefinition getCachedServerInfrInfo() {
        if (serverInfrInfo == null) {
            InstallInfoUtil.getServerInfo();
        }
        return InstallInfoUtil.cloneInfo(serverInfrInfo);
    }

    public static final List<IPluginDefinition> getCachedServerDDInfoList() {
        if (serverDDInfoList == null) {
            InstallInfoUtil.getServerInfo();
        }
        return InstallInfoUtil.cloneList(serverDDInfoList);
    }

    public static final IPluginDefinition getClientInfrInfo() {
        InstallInfoUtil.getClientInfo();
        return InstallInfoUtil.cloneInfo(clientInfrInfo);
    }

    public static final IPluginDefinition getCachedClientInfrInfo() {
        if (clientInfrInfo == null) {
            return InstallInfoUtil.getClientInfrInfo();
        }
        return InstallInfoUtil.cloneInfo(clientInfrInfo);
    }

    public static final List<IPluginDefinition> getClientDDInfoList() {
        InstallInfoUtil.getClientInfo();
        return InstallInfoUtil.cloneList(clientDDInfoList);
    }

    public static final List<IPluginDefinition> getCachedClientDDInfoList() {
        if (clientDDInfoList == null) {
            return InstallInfoUtil.getClientDDInfoList();
        }
        return InstallInfoUtil.cloneList(clientDDInfoList);
    }

    private static final List<IPluginDefinition> cloneList(List<IPluginDefinition> l) {
        ArrayList<IPluginDefinition> r = new ArrayList<IPluginDefinition>();
        r.addAll(l);
        return r;
    }

    private static final PluginDefinition cloneInfo(IPluginDefinition i) {
        return new PluginDefinition(i.getNamespace(), i.getName(), i.getVersion(), i.getInfo(), i.getModule(), i.getNameTranslated());
    }

    private static final void getServerInfo() {
        ServerUtilService serv = null;
        try {
            serv = ServiceRegistry.getServerUtilService();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (serv != null) {
            serverInfrInfo = InstallInfoUtil.cloneInfo(serv.retrieveServerInfrInfo());
            serverDDInfoList = InstallInfoUtil.cloneList(serv.retrieveServerDDInfoList());
            Collections.sort(serverDDInfoList, comparator);
        } else {
            serverInfrInfo = new PluginDefinition("", "", "", "", "", "");
            serverDDInfoList = new ArrayList<IPluginDefinition>();
        }
    }

    private static final void getClientInfo() {
        if (clientDDInfoList == null) {
            clientDDInfoList = new ArrayList<IPluginDefinition>();
        } else {
            clientDDInfoList.clear();
        }
        clientInfrInfo = new PluginDefinition("", "", "", "", "", "");
        Internationalizer ddiI18n = null;
        try {
            File d = new File(PATH_OWAREAPPS);
            if (d.isDirectory()) {
                File[] dirs;
                for (File dir : dirs = d.listFiles()) {
                    File prop;
                    if (!dir.isDirectory() || !(prop = new File(InstallInfoUtil.getFileOwareappsPrjProp(dir.getName()))).isFile()) continue;
                    Properties props = new Properties();
                    FileInputStream in = new FileInputStream(prop);
                    props.load(in);
                    in.close();
                    if (!props.get(PROPERTY_IS_BWANMS_PROJECT).equals(PROPERTY_VALUE_TRUE)) continue;
                    try {
                        String version = props.get(PROPERTY_PROJECT_VERSION_MAJOR) + "." + props.get(PROPERTY_PROJECT_VERSION_MINOR) + "." + props.get(PROPERTY_PROJECT_VERSION_MAINT) + "." + props.get(PROPERTY_PROJECT_VERSION_BUILD);
                        PluginDefinition pluginDef = new PluginDefinition(props.getProperty(PROPERTY_PROJECT_PLUGIN_ID), props.getProperty(PROPERTY_PROJECT_PLUGIN_NAME), version, props.getProperty(PROPERTY_PROJECT_PLUGIN_INFO), props.getProperty(PROPERTY_PROJECT_PLUGIN_MODULE), ddiI18n != null ? ddiI18n.translateString(props.getProperty(PROPERTY_PROJECT_PLUGIN_NAME)) : props.getProperty(PROPERTY_PROJECT_PLUGIN_NAME));
                        if (props.get(PROPERTY_IS_BWANMS_DRIVER).equals(PROPERTY_VALUE_TRUE)) {
                            clientDDInfoList.add(pluginDef);
                            continue;
                        }
                        clientInfrInfo = pluginDef;
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        Collections.sort(clientDDInfoList, comparator);
    }

    public static final String getFileOwareappsPrjProp(String prj) {
        return String.format(FILE_OWAREAPPS_PROJECT_PROPERTIES, prj);
    }

    public static final Comparator<IPluginDefinition> getComparator() {
        return comparator;
    }

    static {
        comparator = new Comparator<IPluginDefinition>(){

            @Override
            public int compare(IPluginDefinition a, IPluginDefinition b) {
                int res = a.getModule().compareTo(b.getModule());
                if (res == 0) {
                    return 0;
                }
                return res < 0 ? -1 : 1;
            }
        };
    }
}

