/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class IOUtil {
    public static final void copyStream(InputStream in, OutputStream out) throws IOException {
        IOUtil.copyStream(in, out, 1024);
    }

    public static final void copyStream(InputStream in, OutputStream out, int bufferSize) throws IOException {
        byte[] buff = new byte[bufferSize];
        int read = 0;
        while ((read = in.read(buff)) > 0) {
            out.write(buff, 0, read);
        }
        out.flush();
    }

    public static final void copyStream(InputStream in, OutputStream out, int bufferSize, long maxBytes) throws IOException {
        byte[] buff = new byte[bufferSize];
        long readCount = 0L;
        int read = 0;
        while ((read = in.read(buff)) > 0) {
            if ((readCount += (long)read) > maxBytes) {
                throw new IOException("Byte count exceeded: " + readCount + " > " + maxBytes);
            }
            out.write(buff, 0, read);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getContents(File aFile) {
        StringBuffer contents = new StringBuffer();
        BufferedReader input = null;
        try {
            input = new BufferedReader(new FileReader(aFile));
            String line = null;
            while ((line = input.readLine()) != null) {
                contents.append(line);
                contents.append(System.getProperty("line.separator"));
            }
        }
        catch (FileNotFoundException ex) {
            ex.printStackTrace();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        finally {
            try {
                if (input != null) {
                    input.close();
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        return contents.toString();
    }

    public static void deleteDir(File dir) {
        File[] content;
        if (dir.isFile()) {
            dir.delete();
        }
        for (File f : content = dir.listFiles()) {
            if (f.isFile()) {
                f.delete();
                continue;
            }
            if (f.delete()) continue;
            IOUtil.deleteDir(f);
        }
        dir.delete();
    }

    public static void unzip(ZipInputStream in, String destDir) throws IOException {
        File destDirFile = new File(destDir);
        destDirFile.mkdirs();
        ZipEntry entry = null;
        String name = null;
        while ((entry = in.getNextEntry()) != null) {
            name = entry.getName();
            File destFile = new File(destDirFile.getAbsolutePath() + "/" + name);
            if (entry.isDirectory()) {
                destFile.mkdirs();
                continue;
            }
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(destFile));
            IOUtil.copyStream(in, out, (int)entry.getCompressedSize());
        }
    }

    public static void deleteFiles(String sourcePath, String deletePath, boolean delNonEmptyDirs, final String[] excludes) {
        File[] list;
        File sourceDir = new File(sourcePath);
        if (!sourceDir.exists() || sourceDir.isFile()) {
            return;
        }
        File deleteDir = new File(deletePath);
        if (!deleteDir.exists() || deleteDir.isFile()) {
            return;
        }
        for (File sourceFile : list = sourceDir.listFiles(new FileFilter(){

            public boolean accept(File pathname) {
                for (String exclude : excludes) {
                    if (!pathname.getName().equals(exclude)) continue;
                    return false;
                }
                return true;
            }
        })) {
            File fileToDel = new File(deleteDir.getAbsolutePath() + "/" + sourceFile.getName());
            if (fileToDel.isDirectory() && delNonEmptyDirs) {
                IOUtil.deleteDir(fileToDel);
                continue;
            }
            fileToDel.delete();
        }
    }

    public static void copyDir(File sourceDir, File destDir) throws IOException {
        File[] list;
        for (File source : list = sourceDir.listFiles()) {
            File dest = new File(destDir.getAbsolutePath() + "/" + source.getName());
            if (source.isDirectory()) {
                dest.mkdirs();
                IOUtil.copyDir(source, dest);
                continue;
            }
            IOUtil.copyFile(source, dest);
        }
    }

    public static void copyFile(File source, File dest) throws IOException {
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(source));
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(dest));
        IOUtil.copyStream(in, out, 1024);
        in.close();
        out.close();
    }
}

