/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.util;

import com.bwanms.craft.CraftMain2;
import com.bwanms.gui.Internationalizer;
import com.bwanms.gui.View;
import com.bwanms.gui.manager.generic.EntityManagerView;
import com.bwanms.gui.taskmanager.TaskEditorFormContainer;
import com.bwanms.gui.taskmanager.TaskManagerMediator;
import com.bwanms.gui.taskmanager.VolatileTaskEditorFormContainer;
import com.bwanms.model.EditorContainer;
import com.bwanms.ui.components.ConfirmationDialog;
import com.bwanms.util.MessageBox;
import com.bwanms.util.PlatformConfiguration;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.KeyAdapter;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import org.apache.log4j.Logger;

public class FrameUtil {
    private static final Internationalizer i18n = Internationalizer.getInternationalizer(FrameUtil.class);
    private static final Logger logger = Logger.getLogger(FrameUtil.class);

    public static void runConfigurationFrame(JFrame frame, String title, JPanel panel, int width, int height) {
        FrameUtil.runFrameInternal(frame, title, panel, width, height, true);
    }

    public static void runFrame(JFrame frame, String title, JPanel panel, int width, int height) {
        FrameUtil.runFrameInternal(frame, title, panel, width, height, false);
    }

    public static void runFrameInternal(final JFrame frame, String title, JPanel panel, int width, int height, boolean resize) {
        frame.setTitle(title);
        frame.setDefaultCloseOperation(2);
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                frame.dispose();
                super.windowClosing(e);
            }
        });
        frame.getContentPane().add(panel);
        int maxWidth = (int)frame.getGraphicsConfiguration().getBounds().getWidth();
        int maxHeight = (int)frame.getGraphicsConfiguration().getBounds().getHeight();
        frame.setSize(width, height);
        frame.setLocation((maxWidth - width) / 2, (maxHeight - height) / 2);
        frame.setResizable(resize);
        frame.setVisible(true);
    }

    public static void runFrame(final JFrame frame, String title, JPanel panel, boolean resize) {
        frame.setTitle(title);
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                frame.dispose();
                super.windowClosing(e);
            }
        });
        frame.getContentPane().add(panel);
        frame.pack();
        frame.setResizable(resize);
        FrameUtil.centerWindow(frame);
        frame.setVisible(true);
    }

    public static void runFrame(final JFrame frame, String title, boolean resize) {
        frame.setTitle(title);
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                frame.dispose();
                super.windowClosing(e);
            }
        });
        frame.pack();
        frame.setResizable(resize);
        FrameUtil.centerWindow(frame);
        frame.setVisible(true);
    }

    public static void runTaskEditorFrame(JFrame frame, String title, JPanel panel, int width, int height, final TaskEditorFormContainer container) {
        frame.setDefaultCloseOperation(2);
        frame.setTitle(title);
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                TaskManagerMediator.removeTaskEditor(container);
            }
        });
        frame.getContentPane().add(panel);
        int maxWidth = (int)frame.getGraphicsConfiguration().getBounds().getWidth();
        int maxHeight = (int)frame.getGraphicsConfiguration().getBounds().getHeight();
        frame.pack();
        frame.setLocation((maxWidth - frame.getWidth()) / 2, (maxHeight - frame.getHeight()) / 2);
        frame.setResizable(false);
        frame.setVisible(true);
    }

    public static void runDialog(JDialog dialog, String title, JPanel panel, int width, int height) {
        FrameUtil.runDialogInternal(dialog, title, panel, width, height, false, true);
    }

    private static void runDialogInternal(final JDialog dialog, String title, JPanel panel, int width, int height, boolean resize, boolean modal) {
        dialog.setTitle(title);
        dialog.setDefaultCloseOperation(2);
        dialog.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                dialog.dispose();
                super.windowClosing(e);
            }
        });
        dialog.getContentPane().add(panel);
        dialog.pack();
        FrameUtil.centerWindow(dialog);
        dialog.setResizable(resize);
        dialog.setModal(modal);
        dialog.setVisible(true);
    }

    public static void runTaskRuntimeResultsForm(final JFrame frame, String title, JPanel panel, int width, int height, final Thread sleeper) {
        frame.setTitle(title);
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                sleeper.interrupt();
                frame.dispose();
                super.windowClosing(e);
            }
        });
        frame.getContentPane().add(panel);
        int maxWidth = (int)frame.getGraphicsConfiguration().getBounds().getWidth();
        int maxHeight = (int)frame.getGraphicsConfiguration().getBounds().getHeight();
        frame.setSize(width, height);
        frame.setLocation((maxWidth - width) / 2, (maxHeight - height) / 2);
        frame.setResizable(true);
        frame.setVisible(true);
    }

    public static void runVolatileTaskRuntimeResultsForm(final JDialog dialog, String title, JPanel panel, int width, int height, final Thread sleeper) {
        dialog.setTitle(title);
        dialog.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                sleeper.interrupt();
                dialog.dispose();
                super.windowClosing(e);
            }
        });
        dialog.add(panel);
        dialog.setSize(width, height);
        FrameUtil.centerWindow(dialog);
        dialog.setResizable(false);
        dialog.setVisible(true);
    }

    public static void runEditorFrame(JFrame frame, String title, JPanel panel, int width, int height, final EditorContainer container) {
        frame.setTitle(title);
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                container.cancelActionPerformed();
                super.windowClosing(e);
            }
        });
        frame.getContentPane().add(panel);
        int maxWidth = (int)frame.getGraphicsConfiguration().getBounds().getWidth();
        int maxHeight = (int)frame.getGraphicsConfiguration().getBounds().getHeight();
        frame.setLocation((maxWidth - width) / 2, (maxHeight - height) / 2);
        frame.pack();
        frame.setResizable(false);
        frame.setVisible(true);
    }

    public static JFrame runEntityManagerView(EntityManagerView managerView, int width, int height, final Runnable runnable) {
        JComponent panel = managerView.getUI();
        final JFrame frame = FrameUtil.createFrame();
        frame.setTitle(panel.getClass().getName());
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                runnable.run();
                frame.dispose();
                super.windowClosing(e);
            }
        });
        frame.getContentPane().add(panel);
        frame.setSize(width, height);
        FrameUtil.centerWindow(frame);
        frame.setVisible(true);
        return frame;
    }

    public static JFrame runView(final View view, int width, int height) {
        JComponent panel = view.getUI();
        final JFrame frame = FrameUtil.createFrame();
        frame.setTitle(view.getTitle());
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                view.cleanup();
                frame.dispose();
            }
        });
        frame.getContentPane().add(panel);
        frame.setSize(width, height);
        FrameUtil.centerWindow(frame);
        frame.setVisible(true);
        return frame;
    }

    @Deprecated
    public static boolean showConfirmation(Component ui) {
        return FrameUtil.showConfirmation(ui, null);
    }

    @Deprecated
    public static boolean showConfirmation(Component ui, String text) {
        return MessageBox.Confirm.showOption(ui, text) == 0;
    }

    @Deprecated
    public static boolean showConfirmation(JComponent ui, String text, String title) {
        return MessageBox.Confirm.showOption(ui, text, title) == 0;
    }

    private static boolean modalConfirmDialog(String text, ConfirmationDialog dialog) {
        ArrayList<Boolean> bool = new ArrayList<Boolean>(1);
        dialog.setBooleanList(bool);
        if (text == null) {
            text = i18n.translateString("ConfirmationText");
        }
        dialog.setConfirmationText(text);
        dialog.pack();
        FrameUtil.centerWindow(dialog);
        dialog.setVisible(true);
        return (Boolean)bool.get(0);
    }

    @Deprecated
    public static boolean showConfirmation(JFrame frame, String text) {
        return MessageBox.Confirm.showOption(frame, text) == 0;
    }

    @Deprecated
    public static void showAlert(JComponent ui, String alertText) {
        MessageBox.Alert.quickShow(ui, alertText);
    }

    @Deprecated
    public static void showError(Component parent, String message, String title) {
        MessageBox.Error.quickShow(parent, message);
    }

    public static void centerWindow(Window window) {
        int maxWidth = (int)window.getGraphicsConfiguration().getBounds().getWidth();
        int maxHeight = (int)window.getGraphicsConfiguration().getBounds().getHeight();
        int width = window.getWidth();
        int height = window.getHeight();
        window.setLocation((maxWidth - width) / 2, (maxHeight - height) / 2);
    }

    public static void addKeyListenerRecursively(Component c, KeyAdapter listener) {
        c.addKeyListener(listener);
        if (c instanceof Container) {
            Container cont = (Container)c;
            Component[] children = cont.getComponents();
            for (int i = 0; i < children.length; ++i) {
                FrameUtil.addKeyListenerRecursively(children[i], listener);
            }
        }
    }

    public static void runTaskEditorFrame(final JFrame frame, String title, JPanel panel, int i, int j, VolatileTaskEditorFormContainer container) {
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                frame.dispose();
                super.windowClosing(e);
            }
        });
        frame.setTitle(title);
        frame.getContentPane().add(panel);
        frame.pack();
        frame.setResizable(false);
        FrameUtil.centerWindow(frame);
        frame.setVisible(true);
    }

    public static void runFrame(final JFrame frame, String title, final View view, int width, int height, boolean resize) {
        logger.debug((Object)("RunFrame for View: " + view.getClass().getName()));
        frame.setDefaultCloseOperation(2);
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                logger.debug((Object)("Performing Cleanup for View: " + view.getClass().getName()));
                view.cleanup();
                view.close();
                frame.dispose();
            }
        });
        frame.getContentPane().add(view.getUI());
        frame.setTitle(title);
        frame.setSize(width, height);
        frame.setResizable(resize);
        FrameUtil.centerWindow(frame);
        frame.setVisible(true);
    }

    public static JFrame createModalFrame(Window owner, boolean returnImmediately) {
        JFrame frame = owner != null ? new ModalFrame(owner, returnImmediately) : new JFrame();
        if (PlatformConfiguration.isLocalPlatform()) {
            try {
                frame.setIconImage(new ImageIcon(CraftMain2.class.getResource("frameIcon.gif")).getImage());
            }
            catch (Exception e) {
                logger.error((Object)"Can't set icon for frame", (Throwable)e);
            }
        }
        return frame;
    }

    public static JFrame createModalFrame(Window owner) {
        return FrameUtil.createModalFrame(owner, false);
    }

    public static JFrame createFrame() {
        return FrameUtil.createModalFrame(null, false);
    }

    public static class ModalFrame
    extends JFrame {
        protected Window owner;
        protected boolean returnImmediately;

        public ModalFrame(Window owner, boolean returnImmediately) {
            this.owner = owner;
            this.returnImmediately = returnImmediately;
        }

        public ModalFrame(Window owner) {
            this.owner = owner;
            this.returnImmediately = false;
        }

        public void setVisible(boolean value) {
            if (value) {
                this.showAsModal();
            } else {
                super.setVisible(false);
            }
        }

        public void dispose() {
            this.dispatchEvent(new WindowEvent(this, 202));
            super.setVisible(false);
            super.dispose();
        }

        public void showAsModal() {
            final ModalFrame frame = this;
            this.addWindowListener(new WindowAdapter(){

                public void windowOpened(WindowEvent e) {
                    ModalFrame.this.owner.setEnabled(false);
                }

                public void windowClosed(WindowEvent e) {
                    ModalFrame.this.owner.setEnabled(true);
                    ModalFrame.this.owner.removeWindowListener(this);
                    ModalFrame.this.owner.toFront();
                }

                public void windowIconified(WindowEvent e) {
                    try {
                        ((Frame)ModalFrame.this.owner).setState(1);
                    }
                    catch (ClassCastException classCastException) {
                        // empty catch block
                    }
                }

                public void windowDeiconified(WindowEvent e) {
                    try {
                        ((Frame)ModalFrame.this.owner).setState(0);
                        ModalFrame.this.owner.repaint();
                    }
                    catch (ClassCastException classCastException) {
                        // empty catch block
                    }
                }
            });
            this.owner.addWindowListener(new WindowAdapter(){

                public void windowActivated(WindowEvent e) {
                    if (frame.isShowing()) {
                        frame.setExtendedState(0);
                        frame.toFront();
                    } else {
                        ModalFrame.this.owner.removeWindowListener(this);
                    }
                }
            });
            super.setVisible(true);
            if (!this.returnImmediately) {
                try {
                    new EventPump(this).start();
                }
                catch (Throwable throwable) {
                    throw new RuntimeException(throwable);
                }
            }
        }

        class EventPump
        implements InvocationHandler {
            Frame pumpframe;

            public EventPump(Frame pumpframe) {
                this.pumpframe = pumpframe;
            }

            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                return this.pumpframe.isShowing() ? Boolean.TRUE : Boolean.FALSE;
            }

            public void start() throws Exception {
                Class<?> clazz = Class.forName("java.awt.Conditional");
                Object conditional = Proxy.newProxyInstance(clazz.getClassLoader(), new Class[]{clazz}, (InvocationHandler)this);
                Method pumpMethod = Class.forName("java.awt.EventDispatchThread").getDeclaredMethod("pumpEventsForHierarchy", clazz, Component.class);
                pumpMethod.setAccessible(true);
                pumpMethod.invoke((Object)Thread.currentThread(), conditional, this.pumpframe);
            }
        }
    }
}

