/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.util;

import com.bwanms.gui.Internationalizer;
import com.bwanms.ui.components.ComboItem;
import com.bwanms.ui.components.ExtensionFileFilter;
import com.bwanms.ui.components.ListItem;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FormUtil {
    protected static Internationalizer i18n = Internationalizer.getInternationalizer(FormUtil.class);

    public static int setSelectedValue(JComboBox combo, Object value) {
        for (int i = 0; i < combo.getItemCount(); ++i) {
            if (!FormUtil.stringsEqualOrNull(((ComboItem)combo.getItemAt(i)).getValue(), value)) continue;
            combo.setSelectedIndex(i);
            return i;
        }
        if (null == value) {
            combo.setSelectedIndex(0);
        }
        return -1;
    }

    public static void addComboItems(JComboBox combo, String[] itemNames) {
        Object[] values = new Object[itemNames.length];
        for (int i = 0; i < itemNames.length; ++i) {
            values[i] = i;
        }
        FormUtil.addComboItems(combo, itemNames, values);
    }

    public static void addComboItems(JComboBox combo, String[] itemNames, Object[] values) {
        if (combo == null || itemNames == null || values == null) {
            return;
        }
        if (itemNames.length != values.length) {
            throw new IllegalArgumentException("Item names and item values arrays have different lengths.");
        }
        int i = 0;
        for (String itemName : itemNames) {
            combo.addItem(new ComboItem(values[i++], itemName));
        }
    }

    public static void addComboItems(JComboBox combo, ComboItem[] items) {
        for (ComboItem item : items) {
            combo.addItem(item);
        }
    }

    private static boolean stringsEqualOrNull(Object s1, Object s2) {
        return null != s1 ? null != s2 && s1.equals(s2) : null == s2;
    }

    public static Object getSelectedValue(JComboBox combo) {
        ComboItem selectedComboItem = (ComboItem)combo.getSelectedItem();
        return selectedComboItem == null ? null : selectedComboItem.getValue();
    }

    public static List<ListItem> getSelectedValue(JList jList) {
        ArrayList<ListItem> listValues = new ArrayList<ListItem>();
        Object[] selectedItems = jList.getSelectedValues();
        for (int i = 0; i < selectedItems.length; ++i) {
            listValues.add((ListItem)selectedItems[i]);
        }
        return listValues;
    }

    public static String getText(JTextField txtField) {
        String stringValue = txtField.getText();
        return stringValue.equals("") ? null : stringValue;
    }

    public static String getText(JTextArea txtField) {
        String stringValue = txtField.getText();
        return stringValue.equals("") ? null : stringValue;
    }

    public static void cancelTableEditing(JTable table) {
        if (table.isEditing()) {
            table.getCellEditor(table.getEditingRow(), table.getEditingColumn()).cancelCellEditing();
        }
    }

    public static void stopTableEditing(JTable table) {
        if (table.isEditing()) {
            table.getCellEditor(table.getEditingRow(), table.getEditingColumn()).stopCellEditing();
        }
    }

    public static File getExportFile(String fileExt, JComponent uiParent) {
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setDialogTitle(i18n.translateString("ExportEquipmentTitle"));
        fileChooser.setAcceptAllFileFilterUsed(false);
        fileChooser.setMultiSelectionEnabled(false);
        fileChooser.setApproveButtonText(i18n.translateString("FileChooserApproveButton"));
        fileChooser.setApproveButtonToolTipText(i18n.translateString("FileChooserApproveButtonToolTip"));
        ExtensionFileFilter fileExtFilter = new ExtensionFileFilter();
        fileExtFilter.addExtension(fileExt);
        fileExtFilter.setDescription(i18n.translateString("ExportEquipmentFilterDescr", "*." + fileExt));
        fileChooser.setFileFilter(fileExtFilter);
        int ret = fileChooser.showOpenDialog(uiParent);
        if (ret == 0) {
            String ext;
            File exportFile = fileChooser.getSelectedFile();
            int lastDotIndex = exportFile.getName().lastIndexOf(46);
            String string = ext = lastDotIndex == -1 ? null : exportFile.getName().substring(lastDotIndex + 1);
            if (!fileExt.equalsIgnoreCase(ext)) {
                exportFile = new File(exportFile.getAbsolutePath() + "." + fileExt);
            }
            return exportFile;
        }
        return null;
    }

    public static File getExportFile(JComponent uiParent, String title, String fileExt, String fileExtDescr) {
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setDialogTitle(title);
        fileChooser.setAcceptAllFileFilterUsed(false);
        fileChooser.setMultiSelectionEnabled(false);
        fileChooser.setApproveButtonText(i18n.translateString("FileChooserApproveButton"));
        fileChooser.setApproveButtonToolTipText(i18n.translateString("FileChooserApproveButtonToolTip"));
        ExtensionFileFilter fileExtFilter = new ExtensionFileFilter();
        fileExtFilter.addExtension(fileExt);
        fileExtFilter.setDescription(fileExtDescr);
        fileChooser.setFileFilter(fileExtFilter);
        int ret = fileChooser.showOpenDialog(uiParent);
        if (ret == 0) {
            String ext;
            File exportFile = fileChooser.getSelectedFile();
            int lastDotIndex = exportFile.getName().lastIndexOf(46);
            String string = ext = lastDotIndex == -1 ? null : exportFile.getName().substring(lastDotIndex + 1);
            if (!fileExt.equalsIgnoreCase(ext)) {
                exportFile = new File(exportFile.getAbsolutePath() + "." + fileExt);
            }
            return exportFile;
        }
        return null;
    }

    public static File getFileFor(JComponent uiParent, String title, String fileExt, String fileExtDescr, boolean exportFlag) {
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setDialogTitle(title);
        fileChooser.setAcceptAllFileFilterUsed(false);
        fileChooser.setMultiSelectionEnabled(false);
        fileChooser.setApproveButtonText(i18n.translateString(exportFlag ? "FileChooserApproveButton" : "FileChooserImportApproveButton"));
        fileChooser.setApproveButtonToolTipText(i18n.translateString(exportFlag ? "FileChooserApproveButtonToolTip" : "FileChooserImportApproveButtonToolTip"));
        ExtensionFileFilter fileExtFilter = new ExtensionFileFilter();
        fileExtFilter.addExtension(fileExt);
        fileExtFilter.setDescription(fileExtDescr);
        fileChooser.setFileFilter(fileExtFilter);
        int ret = fileChooser.showOpenDialog(uiParent);
        if (ret == 0) {
            String ext;
            File exportFile = fileChooser.getSelectedFile();
            int lastDotIndex = exportFile.getName().lastIndexOf(46);
            String string = ext = lastDotIndex == -1 ? null : exportFile.getName().substring(lastDotIndex + 1);
            if (!fileExt.equalsIgnoreCase(ext)) {
                exportFile = new File(exportFile.getAbsolutePath() + "." + fileExt);
            }
            return exportFile;
        }
        return null;
    }

    public static File getImportFile(String fileExt, JComponent uiParent, boolean appendImportExt) {
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setDialogTitle(i18n.translateString("ImportEquipmentTitle"));
        fileChooser.setAcceptAllFileFilterUsed(false);
        fileChooser.setMultiSelectionEnabled(false);
        fileChooser.setApproveButtonText(i18n.translateString("FileChooserImportApproveButton"));
        fileChooser.setApproveButtonToolTipText(i18n.translateString("FileChooserImportApproveButtonToolTip"));
        ExtensionFileFilter fileExtFilter = new ExtensionFileFilter();
        fileExtFilter.addExtension(fileExt);
        fileExtFilter.setDescription(i18n.translateString("ImportEquipmentFilterDescr", "*." + fileExt));
        fileChooser.setFileFilter(fileExtFilter);
        int ret = fileChooser.showOpenDialog(uiParent);
        if (ret == 0) {
            File importFile = fileChooser.getSelectedFile();
            if (appendImportExt) {
                String ext;
                int lastDotIndex = importFile.getName().lastIndexOf(46);
                String string = ext = lastDotIndex == -1 ? null : importFile.getName().substring(lastDotIndex + 1);
                if (!fileExt.equalsIgnoreCase(ext)) {
                    importFile = new File(importFile.getAbsolutePath() + "." + fileExt);
                }
            }
            return importFile;
        }
        return null;
    }

    public static File getImportFile(String fileExt, JComponent uiParent) {
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setDialogTitle(i18n.translateString("ImportEquipmentTitle"));
        fileChooser.setAcceptAllFileFilterUsed(false);
        fileChooser.setMultiSelectionEnabled(false);
        fileChooser.setApproveButtonText(i18n.translateString("FileChooserImportApproveButton"));
        fileChooser.setApproveButtonToolTipText(i18n.translateString("FileChooserImportApproveButtonToolTip"));
        ExtensionFileFilter fileExtFilter = new ExtensionFileFilter();
        fileExtFilter.addExtension(fileExt);
        fileExtFilter.setDescription(i18n.translateString("ImportEquipmentFilterDescr", "*." + fileExt));
        fileChooser.setFileFilter(fileExtFilter);
        int ret = fileChooser.showOpenDialog(uiParent);
        if (ret == 0) {
            String ext;
            File importFile = fileChooser.getSelectedFile();
            int lastDotIndex = importFile.getName().lastIndexOf(46);
            String string = ext = lastDotIndex == -1 ? null : importFile.getName().substring(lastDotIndex + 1);
            if (!fileExt.equalsIgnoreCase(ext)) {
                importFile = new File(importFile.getAbsolutePath() + "." + fileExt);
            }
            return importFile;
        }
        return null;
    }

    public static void equalizeLabelsSize(JPanel panel1, JPanel panel2) {
        int maxWidth2;
        ArrayList<JLabel> panel1Labels = new ArrayList<JLabel>();
        ArrayList<JLabel> panel2Labels = new ArrayList<JLabel>();
        for (Component c : panel1.getComponents()) {
            if (!(c instanceof JLabel)) continue;
            panel1Labels.add((JLabel)c);
        }
        for (Component c : panel2.getComponents()) {
            if (!(c instanceof JLabel)) continue;
            panel2Labels.add((JLabel)c);
        }
        if (panel1Labels.size() == 0 || panel2Labels.size() == 0) {
            return;
        }
        int maxWidth1 = FormUtil.getMaxPreferredSize(panel1Labels);
        if (maxWidth1 > (maxWidth2 = FormUtil.getMaxPreferredSize(panel2Labels))) {
            Dimension maxSize = ((JLabel)panel2Labels.get(0)).getPreferredSize();
            maxSize.width = maxWidth1;
            ((JLabel)panel2Labels.get(0)).setPreferredSize(maxSize);
        } else if (maxWidth2 > maxWidth1) {
            Dimension maxSize = ((JLabel)panel1Labels.get(0)).getPreferredSize();
            maxSize.width = maxWidth2;
            ((JLabel)panel1Labels.get(0)).setPreferredSize(maxSize);
        }
        panel1Labels.clear();
        panel2Labels.clear();
    }

    public static int getMaxPreferredSize(Collection<? extends JComponent> components) {
        int maxPreferredSize = -1;
        for (JComponent jComponent : components) {
            int width = jComponent.getPreferredSize().width;
            if (width <= maxPreferredSize) continue;
            maxPreferredSize = width;
        }
        return maxPreferredSize;
    }

    public static void setEnabled(Container container, boolean value) {
        for (Component component : container.getComponents()) {
            component.setEnabled(value);
        }
    }
}

