/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.util;

import com.bwanms.ddi.Factory;
import com.bwanms.plugin.ExtensionRegistryFactory;
import com.bwanms.plugin.IConfigurationElement;
import com.bwanms.plugin.IExtensionPoint;
import com.bwanms.plugin.IExtensionRegistry;
import org.apache.log4j.Logger;

public class FactoryUtil {
    private static final Logger log = Logger.getLogger(FactoryUtil.class);

    public static Factory getFactory(String ddName) {
        IConfigurationElement[] elements;
        if (ddName == null) {
            throw new IllegalArgumentException("Parameter ddName can't be null");
        }
        IExtensionRegistry registry = ExtensionRegistryFactory.getExtensionRegistry();
        IExtensionPoint extensionPoint = registry.getExtensionPoint("com.bwanms.factory");
        for (IConfigurationElement element : elements = extensionPoint.getConfigurationElements()) {
            String attDdName = element.getAttribute("ddName");
            if (!ddName.equalsIgnoreCase(attDdName)) continue;
            log.info((Object)String.format("%s: found class %s ddName %s", element.getName(), element.getAttribute("class"), attDdName));
            return (Factory)element.createExecutableExtension("class");
        }
        throw new RuntimeException("Device driver " + ddName + " doesn't have an extension declaration for extension-point com.bwanms.factory or attribute 'ddName' is not defined!");
    }
}

