/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.util;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;

public class ExecutorUtils {
    private static final Logger log = Logger.getLogger(ExecutorUtils.class);

    public static void shutdownAndWait(String name, ExecutorService pool) {
        ExecutorUtils.shutdownAndWait(name, pool, 2);
    }

    public static void shutdownAndWait(String name, ExecutorService pool, int secondsToWait) {
        log.info((Object)("Executor [" + name + "] shutdown ... "));
        pool.shutdown();
        try {
            log.info((Object)("Executor [" + name + "] shutdown ... wait to finish."));
            if (!pool.awaitTermination(secondsToWait, TimeUnit.SECONDS)) {
                log.info((Object)("Executor [" + name + "] shutdown ... waited too much. Force shutdown."));
                pool.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            log.info((Object)("Executor [" + name + "] shutdown ... waiting interrupted. Force shutdown."));
            pool.shutdownNow();
        }
        log.info((Object)("Executor [" + name + "] shutdown finished."));
    }

    public static ExecutorService newCachedThreadPool(int maxThreads, int timeout, ThreadFactory threadFactory) {
        return new ThreadPoolExecutor(0, maxThreads, (long)timeout, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), threadFactory);
    }
}

