/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.util;

import com.bwanms.model.entity.EntityHandler;
import com.bwanms.plugin.ExtensionRegistryFactory;
import com.bwanms.plugin.IConfigurationElement;
import com.bwanms.plugin.IExtension;
import com.bwanms.plugin.IExtensionPoint;
import com.bwanms.plugin.IExtensionRegistry;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntityHandlerPluginUtil {
    private static final Logger log;
    private static Map<Class, Class> supportedHandlers;

    public static <T extends Serializable> EntityHandler<T> getHandlerForEntity(Class<T> class1) {
        try {
            return (EntityHandler)supportedHandlers.get(class1).newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static {
        IExtension[] extensions;
        log = Logger.getLogger(EntityHandlerPluginUtil.class);
        supportedHandlers = new HashMap<Class, Class>();
        IExtensionRegistry extensionRegistry = ExtensionRegistryFactory.getExtensionRegistry();
        IExtensionPoint extensionPoint = extensionRegistry.getExtensionPoint("com.bwanms.entityHandler");
        for (IExtension extension : extensions = extensionPoint.getExtensions()) {
            IConfigurationElement[] configElements;
            for (IConfigurationElement element : configElements = extension.getConfigurationElements()) {
                try {
                    Class<?> entityClass = Class.forName(element.getAttribute("entity"));
                    Class<?> handlerClass = Class.forName(element.getAttribute("handler"));
                    if (!EntityHandler.class.isAssignableFrom(handlerClass)) {
                        throw new RuntimeException("Invalid entity handler " + handlerClass.getName());
                    }
                    supportedHandlers.put(entityClass, handlerClass);
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }
}

