/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.util;

import com.bwanms.platform.PlatformFactory;
import java.io.Serializable;

public class DatastoreOperationUtil {
    public static Runnable publishMessageOperation(String topicName, Serializable message) {
        return new PublishMessageOperation(topicName, message);
    }

    public static Runnable sendMessageOperation(String queueName, Serializable message) {
        return new SendMessageOperation(queueName, message);
    }

    private static class SendMessageOperation
    implements Runnable {
        private String queueName;
        private Serializable message;

        public SendMessageOperation(String queueName, Serializable message) {
            this.queueName = queueName;
            this.message = message;
        }

        public void run() {
            PlatformFactory.getApplicationLayerPlatform().getMessaging().send(this.queueName, this.message);
        }
    }

    private static class PublishMessageOperation
    implements Runnable {
        private String topicName;
        private Serializable message;

        public PublishMessageOperation(String topicName, Serializable message) {
            this.topicName = topicName;
            this.message = message;
        }

        public void run() {
            PlatformFactory.getApplicationLayerPlatform().getMessaging().publish(this.topicName, this.message);
        }
    }
}

