/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.util;

import com.bwanms.plugin.ExtensionRegistryFactory;
import com.bwanms.plugin.IConfigurationElement;
import com.bwanms.plugin.IExtension;
import com.bwanms.plugin.IExtensionPoint;
import com.bwanms.plugin.IExtensionRegistry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DDPluginUtil {
    private static final transient Logger log = Logger.getLogger(DDPluginUtil.class);
    private static IExtension[] extensions;
    private static Map<String, String> classNamesForOIDCache;

    public static String getClassNameForOId(String oId) {
        String className = classNamesForOIDCache.get(oId);
        if (className == null) {
            for (IExtension extension : extensions) {
                IConfigurationElement[] elements;
                IConfigurationElement[] configElements = extension.getConfigurationElements();
                for (IConfigurationElement element : elements = configElements[0].getChildren()[0].getChildren()) {
                    if (!oId.equals(element.getAttribute("oid"))) continue;
                    className = element.getAttribute("class");
                    classNamesForOIDCache.put(oId, className);
                    return className;
                }
            }
        }
        return className;
    }

    public static List<String> getSupportedEquipment() {
        ArrayList<String> ret = new ArrayList<String>();
        IExtensionRegistry extensionRegistry = ExtensionRegistryFactory.getExtensionRegistry();
        IExtensionPoint extensionPoint = extensionRegistry.getExtensionPoint("com.bwanms.supportedEquipment");
        for (IExtension extension : extensionPoint.getExtensions()) {
            IConfigurationElement[] configElements;
            for (IConfigurationElement element : configElements = extension.getConfigurationElements()) {
                ret.add(element.getAttribute("class"));
            }
        }
        return ret;
    }

    static {
        IExtensionRegistry extensionRegistry = ExtensionRegistryFactory.getExtensionRegistry();
        IExtensionPoint extensionPoint = extensionRegistry.getExtensionPoint("com.bwanms.deviceDriver");
        extensions = extensionPoint.getExtensions();
        classNamesForOIDCache = new HashMap<String, String>();
    }
}

