/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.util;

import com.bwanms.ddi.CutThroughNotSupportedException;
import com.bwanms.ddi.CutThroughStrategy;
import com.bwanms.model.Equipment;
import com.bwanms.plugin.ExtensionRegistryFactory;
import com.bwanms.plugin.IConfigurationElement;
import com.bwanms.plugin.IExtensionPoint;
import com.bwanms.plugin.IExtensionRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CutThroughPluginUtil {
    public static boolean isCutThroughSupported(Class<? extends Equipment> clazz) {
        IConfigurationElement[] elements;
        IExtensionRegistry extensionRegistry = ExtensionRegistryFactory.getExtensionRegistry();
        IExtensionPoint extensionPoint = extensionRegistry.getExtensionPoint("com.bwanms.cutThrough");
        for (IConfigurationElement element : elements = extensionPoint.getConfigurationElements()) {
            String targetClass = element.getAttribute("targetClass");
            if (!targetClass.equals(clazz.getName())) continue;
            return true;
        }
        return false;
    }

    public static void performCutThrough(Equipment equipment) throws CutThroughNotSupportedException {
        IConfigurationElement[] elements;
        Class<?> clazz = equipment.getClass();
        if (!CutThroughPluginUtil.isCutThroughSupported(clazz)) {
            throw new CutThroughNotSupportedException("Cut through not supported for " + equipment.getName());
        }
        IExtensionRegistry extensionRegistry = ExtensionRegistryFactory.getExtensionRegistry();
        IExtensionPoint extensionPoint = extensionRegistry.getExtensionPoint("com.bwanms.cutThrough");
        for (IConfigurationElement element : elements = extensionPoint.getConfigurationElements()) {
            String targetClass = element.getAttribute("targetClass");
            if (!targetClass.equals(clazz.getName())) continue;
            CutThroughStrategy strategy = (CutThroughStrategy)element.createExecutableExtension("class");
            strategy.performCutThrough(equipment);
            break;
        }
    }

    public static void performCutThrough(String ip) throws CutThroughNotSupportedException {
        IExtensionRegistry extensionRegistry = ExtensionRegistryFactory.getExtensionRegistry();
        IExtensionPoint extensionPoint = extensionRegistry.getExtensionPoint("com.bwanms.cutThrough");
        IConfigurationElement[] elements = extensionPoint.getConfigurationElements();
        if (elements.length != 0) {
            IConfigurationElement element = elements[0];
            CutThroughStrategy strategy = (CutThroughStrategy)element.createExecutableExtension("class");
            strategy.performCutThrough(ip);
        }
    }
}

