/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.util;

import com.bwanms.ddi.EquipmentConfigSectionFactory;
import com.bwanms.model.ConfigFileImporter;
import com.bwanms.model.ConfigurationErrorHandler;
import com.bwanms.model.DefaultEquipmentPropertiesHandler;
import com.bwanms.model.EquipmentPropertiesHandler;
import com.bwanms.model.file.BackupConfigFile;
import com.bwanms.plugin.ExtensionRegistryFactory;
import com.bwanms.plugin.IConfigurationElement;
import com.bwanms.plugin.IExtension;
import com.bwanms.plugin.IExtensionPoint;
import com.bwanms.plugin.IExtensionRegistry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigurationPluginUtil {
    private static final Logger log = Logger.getLogger(ConfigurationPluginUtil.class);
    private Map<String, EquipmentConfigSectionFactory> equipmentConfigSectionFactories = new HashMap<String, EquipmentConfigSectionFactory>();
    private List<ConfigFileImporter> importers;
    private List<BackupConfigFile> configBackupInstances;
    private List<ConfigurationErrorHandler> configErrorHandlers;
    private EquipmentPropertiesHandler equipmentPropertiesHandler;

    public void configure() {
        IConfigurationElement[] configElements;
        IExtensionRegistry extensionRegistry = ExtensionRegistryFactory.getExtensionRegistry();
        IExtensionPoint extensionPoint = null;
        IConfigurationElement[] elements = null;
        extensionPoint = extensionRegistry.getExtensionPoint("com.bwanms.equipmentConfigSectionFactory");
        for (IConfigurationElement element : elements = extensionPoint.getConfigurationElements()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("extension [%s]: factoryClass=[%s] equipmentClass=[%s]", "com.bwanms.equipmentConfigSectionFactory", element.getAttribute("factoryClass"), element.getAttribute("equipmentClass")));
            }
            this.equipmentConfigSectionFactories.put(element.getAttribute("equipmentClass") + element.getAttribute("type"), (EquipmentConfigSectionFactory)element.createExecutableExtension("factoryClass"));
        }
        extensionPoint = extensionRegistry.getExtensionPoint("com.bwanms.configFileImporter");
        IExtension[] extensions = extensionPoint.getExtensions();
        this.importers = new ArrayList<ConfigFileImporter>();
        for (IExtension extension : extensions) {
            for (IConfigurationElement element : configElements = extension.getConfigurationElements()) {
                try {
                    ConfigFileImporter importer = (ConfigFileImporter)Class.forName(element.getAttribute("class")).newInstance();
                    this.importers.add(importer);
                }
                catch (InstantiationException e) {
                    log.error((Object)e, (Throwable)e);
                }
                catch (IllegalAccessException e) {
                    log.error((Object)e, (Throwable)e);
                }
                catch (ClassNotFoundException e) {
                    log.error((Object)e, (Throwable)e);
                }
            }
        }
        extensionPoint = extensionRegistry.getExtensionPoint("com.bwanms.configurationBackup");
        extensions = extensionPoint.getExtensions();
        this.configBackupInstances = new ArrayList<BackupConfigFile>();
        for (IExtension extension : extensions) {
            for (IConfigurationElement element : configElements = extension.getConfigurationElements()) {
                try {
                    BackupConfigFile backup = (BackupConfigFile)Class.forName(element.getAttribute("class")).newInstance();
                    this.configBackupInstances.add(backup);
                }
                catch (InstantiationException e) {
                    log.error((Object)e, (Throwable)e);
                }
                catch (IllegalAccessException e) {
                    log.error((Object)e, (Throwable)e);
                }
                catch (ClassNotFoundException e) {
                    log.error((Object)e, (Throwable)e);
                }
            }
        }
        extensionPoint = extensionRegistry.getExtensionPoint("com.bwanms.configurationErrorHandlers");
        extensions = extensionPoint.getExtensions();
        this.configErrorHandlers = new ArrayList<ConfigurationErrorHandler>();
        for (IExtension extension : extensions) {
            for (IConfigurationElement element : configElements = extension.getConfigurationElements()) {
                try {
                    ConfigurationErrorHandler errHandler = (ConfigurationErrorHandler)Class.forName(element.getAttribute("class")).newInstance();
                    this.configErrorHandlers.add(errHandler);
                }
                catch (InstantiationException e) {
                    log.error((Object)e, (Throwable)e);
                }
                catch (IllegalAccessException e) {
                    log.error((Object)e, (Throwable)e);
                }
                catch (ClassNotFoundException e) {
                    log.error((Object)e, (Throwable)e);
                }
            }
        }
        extensionPoint = extensionRegistry.getExtensionPoint("com.bwanms.equipmentPropertiesHandlers");
        for (IExtension extension : extensions = extensionPoint.getExtensions()) {
            for (IConfigurationElement element : configElements = extension.getConfigurationElements()) {
                try {
                    this.equipmentPropertiesHandler = (EquipmentPropertiesHandler)Class.forName(element.getAttribute("class")).newInstance();
                }
                catch (InstantiationException e) {
                    log.error((Object)e, (Throwable)e);
                }
                catch (IllegalAccessException e) {
                    log.error((Object)e, (Throwable)e);
                }
                catch (ClassNotFoundException e) {
                    log.error((Object)e, (Throwable)e);
                }
            }
        }
        if (this.equipmentPropertiesHandler == null) {
            this.equipmentPropertiesHandler = new DefaultEquipmentPropertiesHandler();
        }
    }

    public EquipmentConfigSectionFactory getEquipmentConfigSectionFactory(String equipmentClass) {
        return this.equipmentConfigSectionFactories.get(equipmentClass);
    }

    private ConfigurationPluginUtil() {
        this.configure();
    }

    public static ConfigurationPluginUtil getInstance() {
        return new ConfigurationPluginUtil();
    }

    public List<ConfigFileImporter> getConfigFileImporters() {
        return this.importers;
    }

    public List<ConfigurationErrorHandler> getConfigErrorHandlers() {
        return this.configErrorHandlers;
    }

    public EquipmentPropertiesHandler getEquipmentPropertiesHandlers() {
        return this.equipmentPropertiesHandler;
    }
}

