/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.util;

import com.bwanms.ddi.ConfigLaunchNotSupportedException;
import com.bwanms.ddi.ConfigLauncher;
import com.bwanms.model.Equipment;
import com.bwanms.plugin.ExtensionRegistryFactory;
import com.bwanms.plugin.IConfigurationElement;
import com.bwanms.plugin.IExtensionPoint;
import com.bwanms.plugin.IExtensionRegistry;
import com.bwanms.util.MessageBox;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ConfigLauncherPluginUtil {
    public static boolean isConfigLaunchSupported(Class<? extends Equipment> clazz) {
        IConfigurationElement[] elements;
        IExtensionRegistry extensionRegistry = ExtensionRegistryFactory.getExtensionRegistry();
        IExtensionPoint extensionPoint = extensionRegistry.getExtensionPoint("com.bwanms.configLauncher");
        for (IConfigurationElement element : elements = extensionPoint.getConfigurationElements()) {
            String targetClass = element.getAttribute("targetClass");
            if (!targetClass.equals(clazz.getName())) continue;
            return true;
        }
        return false;
    }

    public static void performConfigLaunch(Equipment equipment) throws ConfigLaunchNotSupportedException {
        IConfigurationElement[] elements;
        Class<?> clazz = equipment.getClass();
        if (!ConfigLauncherPluginUtil.isConfigLaunchSupported(clazz)) {
            throw new ConfigLaunchNotSupportedException("Config launcher not supported for " + equipment.getName());
        }
        IExtensionRegistry extensionRegistry = ExtensionRegistryFactory.getExtensionRegistry();
        IExtensionPoint extensionPoint = extensionRegistry.getExtensionPoint("com.bwanms.configLauncher");
        for (IConfigurationElement element : elements = extensionPoint.getConfigurationElements()) {
            String targetClass = element.getAttribute("targetClass");
            if (!targetClass.equals(clazz.getName())) continue;
            ConfigLauncher launcher = (ConfigLauncher)element.createExecutableExtension("class");
            if (equipment.isReachable()) {
                launcher.launch(equipment);
                break;
            }
            MessageBox.Alert.quickShow("Equipment is not reachable!");
            break;
        }
    }

    public static void performConfigLaunch(Equipment equipment, int moType, String moInstance) throws ConfigLaunchNotSupportedException {
        IConfigurationElement[] elements;
        Class<?> clazz = equipment.getClass();
        if (!ConfigLauncherPluginUtil.isConfigLaunchSupported(clazz)) {
            throw new ConfigLaunchNotSupportedException("Config launcher not supported for " + equipment.getName());
        }
        IExtensionRegistry extensionRegistry = ExtensionRegistryFactory.getExtensionRegistry();
        IExtensionPoint extensionPoint = extensionRegistry.getExtensionPoint("com.bwanms.configLauncher");
        for (IConfigurationElement element : elements = extensionPoint.getConfigurationElements()) {
            String targetClass = element.getAttribute("targetClass");
            if (!targetClass.equals(clazz.getName())) continue;
            ConfigLauncher launcher = (ConfigLauncher)element.createExecutableExtension("class");
            if (equipment.isReachable()) {
                launcher.launch(equipment, moType, moInstance);
                break;
            }
            MessageBox.Alert.quickShow("Equipment is not reachable!");
            break;
        }
    }
}

