/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassMap<V> {
    private TreeNode root = new TreeNode(null, null);

    public void put(Class<?> clazz, V value) {
        this.root.insert(new TreeNode(clazz, value));
    }

    public final void put(ClassLoader classLoader, String clazz, V value) throws ClassNotFoundException {
        this.put(classLoader.loadClass(clazz), value);
    }

    public V get(Class clazz) {
        return this.root.get(clazz);
    }

    public LinkedHashMap<Class<?>, V> findBottomUp(Class clazz) {
        LinkedHashMap ret = new LinkedHashMap();
        this.root.findBottomUp(clazz, ret);
        return ret;
    }

    public LinkedHashMap<Class<?>, V> findTopDown(Class clazz) {
        LinkedHashMap ret = new LinkedHashMap();
        this.root.findTopDown(clazz, ret);
        return ret;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TreeNode {
        TreeNode parent;
        Class<?> clazz;
        ArrayList<TreeNode> children = new ArrayList();
        V value;

        public TreeNode(Class clazz, V value) {
            this.clazz = clazz;
            this.value = value;
        }

        public boolean insert(TreeNode node) {
            if (this.clazz != null && !this.clazz.isAssignableFrom(node.clazz)) {
                return false;
            }
            Object childSubClass = null;
            for (TreeNode child : this.children) {
                if (!child.insert(node)) continue;
                return true;
            }
            Iterator<TreeNode> ci = this.children.iterator();
            while (ci.hasNext()) {
                TreeNode child;
                child = ci.next();
                if (!node.clazz.isAssignableFrom(child.clazz)) continue;
                ci.remove();
                child.parent = node;
                node.children.add(child);
            }
            this.addChild(node);
            return true;
        }

        protected void addChild(TreeNode child) {
            child.parent = this;
            this.children.add(child);
        }

        public V get(Class targetClazz) {
            if (this.clazz != null && !this.clazz.isAssignableFrom(targetClazz)) {
                return null;
            }
            for (TreeNode child : this.children) {
                Object val = child.get(targetClazz);
                if (val == null) continue;
                return val;
            }
            if (this.clazz != null && targetClazz.isAssignableFrom(this.clazz)) {
                return this.value;
            }
            return null;
        }

        public void findBottomUp(Class targetClazz, LinkedHashMap<Class<?>, V> retMap) {
            if (this.clazz != null && !this.clazz.isAssignableFrom(targetClazz)) {
                return;
            }
            for (TreeNode child : this.children) {
                child.findBottomUp(targetClazz, retMap);
            }
            if (this.clazz != null) {
                retMap.put(this.clazz, this.value);
            }
        }

        public void findTopDown(Class targetClazz, LinkedHashMap<Class<?>, V> retMap) {
            if (this.clazz != null && !targetClazz.isAssignableFrom(this.clazz)) {
                return;
            }
            for (TreeNode child : this.children) {
                this.findTopDown(targetClazz, retMap);
            }
            for (TreeNode child : this.children) {
                if (!targetClazz.isAssignableFrom(child.clazz)) continue;
                retMap.put(child.clazz, child.value);
            }
        }
    }
}

