/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.util;

import com.bwanms.meta.snmp.SNMPParameter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.hibernate.Hibernate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanUtils {
    private static final Logger log = Logger.getLogger(BeanUtils.class);
    private static HashMap<String, String[]> propertyCache = new HashMap();
    private static HashMap<String, Method[]> propertyGettersCache = new HashMap();
    private static HashMap<String, Method[]> propertySettersCache = new HashMap();
    public static Object[] NO_PARAMS = new Object[0];

    public static boolean equalsBasedOnSerialization(Object arg0, Object arg1) {
        try {
            return BeanUtils.serialize(arg0).equals(BeanUtils.serialize(arg1));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean equals(Object arg0, Object arg1) {
        return BeanUtils.equals(arg0, arg1, 10);
    }

    public static boolean equals(Object arg0, Object arg1, int level) {
        if (level == -1) {
            return true;
        }
        if (arg0 == arg1) {
            return true;
        }
        if (arg0 == null) {
            return false;
        }
        Method[] method = arg1.getClass().getMethods();
        for (int i = 0; i < method.length; ++i) {
            Method getter = method[i];
            if (!getter.getName().toString().startsWith("get") || getter.getParameterTypes().length != 0 || !getter.getDeclaringClass().toString().equals(arg1.getClass().toString())) continue;
            try {
                Object value0 = getter.invoke(arg0, (Object[])null);
                Object value1 = getter.invoke(arg1, (Object[])null);
                if (!(value1 != null ? !BeanUtils.equals2(value1, value0, level - 1) : value0 != null)) continue;
                return false;
            }
            catch (IllegalArgumentException e) {
                log.warn((Object)("error for " + arg0.getClass().getName() + "." + getter.getName() + "()"), (Throwable)e);
                continue;
            }
            catch (IllegalAccessException e) {
                log.warn((Object)("error for " + arg0.getClass().getName() + "." + getter.getName() + "()"), (Throwable)e);
                continue;
            }
            catch (InvocationTargetException e) {
                log.warn((Object)("error for " + arg0.getClass().getName() + "." + getter.getName() + "()"), (Throwable)e);
            }
        }
        return true;
    }

    private static boolean equals2(Object value1, Object value0, int level) {
        return value1.equals(value0);
    }

    public static String toString(Object object) {
        StringBuffer sb = new StringBuffer("[");
        Method[] method = object.getClass().getMethods();
        for (int i = 0; i < method.length; ++i) {
            Method getter = method[i];
            if (!getter.getName().toString().startsWith("get") || !getter.getDeclaringClass().toString().equals(object.getClass().toString())) continue;
            sb.append(getter.getName().toString().substring(3));
            try {
                sb.append("=" + getter.invoke(object, new Object[0]));
                sb.append(",");
                continue;
            }
            catch (IllegalArgumentException e) {
                log.warn((Object)"equals() - exception ignored", (Throwable)e);
                continue;
            }
            catch (IllegalAccessException e) {
                log.warn((Object)"equals() - exception ignored", (Throwable)e);
                continue;
            }
            catch (InvocationTargetException e) {
                log.warn((Object)"equals() - exception ignored", (Throwable)e);
            }
        }
        sb.append("]");
        System.out.println(sb.toString());
        return sb.toString();
    }

    public static Object clone(Object object) {
        try {
            byte[] buf = BeanUtils.serialize(object);
            ByteArrayInputStream bais = new ByteArrayInputStream(buf);
            ObjectInputStream ois = new ObjectInputStream(bais);
            Object result = ois.readObject();
            ois.close();
            return result;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static byte[] serialize(Object object) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(100);
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(object);
        byte[] buf = baos.toByteArray();
        oos.close();
        return buf;
    }

    public static Object getPropertyValue(Object bean, String property) {
        try {
            return BeanUtils.getGetterMethod(bean, property).invoke(bean, new Object[0]);
        }
        catch (Throwable e) {
            log.error((Object)("Can't getProperty: [-" + property + "]"));
            throw new RuntimeException("Can't getProperty: [" + bean.getClass() + "-" + property + "].", e);
        }
    }

    public static void setPropertyValue(Object bean, String property, Class propertyClass, Object value) {
        try {
            BeanUtils.getSetterMethod(bean, property, propertyClass).invoke(bean, value);
        }
        catch (Throwable e) {
            throw new RuntimeException("For bean [" + bean.getClass() + "] can't setProperty [" + property + "] of type [" + propertyClass + "] to value [" + value + "]", e);
        }
    }

    public static void setPropertyValue(Object bean, String property, Object value) {
        Class<?> propertyClass = null;
        if (value != null) {
            propertyClass = value.getClass();
        }
        try {
            Method setterMethod = BeanUtils.getSetterMethod(bean, property, propertyClass);
            setterMethod.invoke(bean, value);
        }
        catch (Throwable e) {
            throw new RuntimeException("For bean [" + bean.getClass() + "] can't setProperty [" + property + "] of type [" + propertyClass + "] to value [" + value + "]", e);
        }
    }

    private static Method getGetterMethod(Object bean, String property) throws NoSuchMethodException {
        return bean.getClass().getMethod(BeanUtils.getGetterName(property), new Class[0]);
    }

    private static Method getSetterMethod(Object bean, String property, Class parameterClass) throws NoSuchMethodException {
        return BeanUtils.getSetter(bean.getClass(), property, parameterClass);
    }

    public static String getGetterName(String property) {
        return "get" + Character.toUpperCase(property.charAt(0)) + property.substring(1);
    }

    private static String getSetterName(String property) {
        return "set" + Character.toUpperCase(property.charAt(0)) + property.substring(1);
    }

    public static Method[] getPropertyGetters(Class objectClass) {
        Method[] ret = propertyGettersCache.get(objectClass.getName());
        if (ret == null) {
            BeanUtils.loadProperties(objectClass);
            ret = propertyGettersCache.get(objectClass.getName());
        }
        return ret;
    }

    public static Method[] getPropertySetters(Class objectClass) {
        Method[] ret = propertySettersCache.get(objectClass.getName());
        if (ret == null) {
            BeanUtils.loadProperties(objectClass);
            ret = propertySettersCache.get(objectClass.getName());
        }
        return ret;
    }

    public static String[] getProperties(Class objectClass) {
        log.debug((Object)("getProperties: " + objectClass.getName()));
        String[] ret = propertyCache.get(objectClass.getName());
        if (ret == null) {
            BeanUtils.loadProperties(objectClass);
            ret = propertyCache.get(objectClass.getName());
        }
        return ret;
    }

    private static synchronized void loadProperties(Class objectClass) {
        if (!propertyCache.containsKey(objectClass.getName())) {
            ArrayList<String> properties = new ArrayList<String>();
            ArrayList<Method> getters = new ArrayList<Method>();
            ArrayList<Method> setters = new ArrayList<Method>();
            for (Method method : objectClass.getMethods()) {
                String methodName = method.getName();
                if (methodName.startsWith("get") && method.getParameterTypes().length == 0) {
                    getters.add(method);
                    properties.add(BeanUtils.getPropertyNameFromGetter(method));
                    continue;
                }
                if (!methodName.startsWith("set") || method.getParameterTypes().length != 1) continue;
                setters.add(method);
            }
            propertyCache.put(objectClass.getName(), properties.toArray(new String[properties.size()]));
            propertyGettersCache.put(objectClass.getName(), getters.toArray(new Method[getters.size()]));
            propertySettersCache.put(objectClass.getName(), setters.toArray(new Method[getters.size()]));
        }
    }

    public static String getPropertyName(String accessorName) {
        StringBuilder propertyName = new StringBuilder(accessorName);
        propertyName.delete(0, 3);
        propertyName.setCharAt(0, Character.toLowerCase(propertyName.charAt(0)));
        return propertyName.toString();
    }

    public static String getPropertyNameFromGetter(Method getter) {
        return BeanUtils.getPropertyName(getter.getName());
    }

    public static Method getGetter(Class bean, String property) {
        try {
            return bean.getMethod(BeanUtils.getGetterName(property), new Class[0]);
        }
        catch (SecurityException e) {
            throw new RuntimeException("Can't getProperty [" + property + "] for bean [" + bean.getClass() + "].", e);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Can't getProperty [" + property + "] for bean [" + bean.getClass() + "].", e);
        }
    }

    public static Method getSetter(Class bean, String property) {
        return BeanUtils.getSetter(bean, property, null);
    }

    public static Method getSetter(Class clazz, String property, Class propertyClass) {
        try {
            if (propertyClass == null) {
                String setterName = BeanUtils.getSetterName(property);
                for (Method method : clazz.getMethods()) {
                    if (!method.getName().equals(setterName)) continue;
                    return method;
                }
                return null;
            }
            return clazz.getMethod(BeanUtils.getSetterName(property), propertyClass);
        }
        catch (SecurityException e) {
            throw new RuntimeException("Can't setProperty [" + property + "] of type [" + propertyClass + "] for bean [" + clazz.getClass() + "].", e);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Can't setProperty [" + property + "] of type [" + propertyClass + "] for bean [" + clazz.getClass() + "].", e);
        }
    }

    public static <T extends Annotation> Map<Method, T> getAnnotatedSetters(Class bean, String[] properties, Class<T> annotationClass) {
        LinkedList<String> remainingProperties = null;
        if (properties != null) {
            Arrays.sort(properties);
            remainingProperties = new LinkedList<String>();
            for (String p : properties) {
                remainingProperties.add(p);
            }
        }
        Method[] getters = BeanUtils.getPropertyGetters(bean);
        HashMap<Method, T> ret = new HashMap<Method, T>(properties != null ? properties.length : getters.length);
        for (Method getter : getters) {
            T annotation = getter.getAnnotation(annotationClass);
            String property = BeanUtils.getPropertyNameFromGetter(getter);
            if (annotation == null || properties != null && Arrays.binarySearch(properties, property) < 0) continue;
            Method setter = BeanUtils.getSetter(bean, property);
            ret.put(setter, annotation);
            if (remainingProperties == null) continue;
            while (remainingProperties.remove(property)) {
            }
        }
        if (remainingProperties != null && remainingProperties.size() != 0) {
            throw new RuntimeException("Setters not found for next properties: " + remainingProperties);
        }
        return ret;
    }

    public static boolean equalsNullAware(Object a, Object b) {
        if (a == null) {
            return b == null;
        }
        if (b == null) {
            return false;
        }
        return a.equals(b);
    }

    public static boolean deepEquals(Object a, Object b) {
        try {
            if (a == null) {
                return b == null;
            }
            if (b == null) {
                return false;
            }
            Class<?> aClass = a.getClass();
            if (!aClass.equals(b.getClass())) {
                return false;
            }
            if (aClass.isPrimitive() || String.class.isAssignableFrom(aClass)) {
                return a.equals(b);
            }
            if (List.class.isAssignableFrom(aClass)) {
                List aList = (List)a;
                List bList = (List)b;
                if (aList.size() != bList.size()) {
                    return false;
                }
                for (int i = 0; i < aList.size(); ++i) {
                    if (BeanUtils.deepEquals(aList.get(i), bList.get(i))) continue;
                    return false;
                }
                return true;
            }
            if (Set.class.isAssignableFrom(aClass)) {
                Set aSet = (Set)a;
                Set bSet = (Set)b;
                if (aSet.size() != bSet.size()) {
                    return false;
                }
                for (Object aValue : aSet) {
                    boolean match = false;
                    for (Object bValue : bSet) {
                        if (!BeanUtils.deepEquals(aValue, bValue)) continue;
                        match = true;
                        break;
                    }
                    if (match) continue;
                    return false;
                }
            }
            for (Method getter : BeanUtils.getPropertyGetters(aClass)) {
                Object aValue;
                Object bValue;
                String propertyName = BeanUtils.getPropertyNameFromGetter(getter);
                if (!Hibernate.isPropertyInitialized((Object)a, (String)propertyName) || BeanUtils.deepEquals(aValue = getter.invoke(a, NO_PARAMS), bValue = getter.invoke(b, NO_PARAMS))) continue;
                return false;
            }
            return true;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void shallowCopy(Object source, Object target) {
        for (Method getter : BeanUtils.getPropertyGetters(source.getClass())) {
            String propertyName = BeanUtils.getPropertyNameFromGetter(getter);
            Method setter = null;
            try {
                setter = BeanUtils.getSetter(target.getClass(), propertyName);
            }
            catch (Exception e) {
                log.debug((Object)e.getMessage());
            }
            if (setter == null) continue;
            try {
                setter.invoke(target, getter.invoke(source, NO_PARAMS));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static void shallowCopy(Object source, Object target, Class<? extends Annotation> annotation) {
        for (Method getter : BeanUtils.getAnnotatedPropertyGetters(source.getClass(), annotation)) {
            String propertyName = BeanUtils.getPropertyNameFromGetter(getter);
            Method setter = null;
            try {
                setter = BeanUtils.getSetter(target.getClass(), propertyName);
            }
            catch (Exception e) {
                log.debug((Object)e.getMessage());
            }
            if (setter == null) continue;
            try {
                setter.invoke(target, getter.invoke(source, NO_PARAMS));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static List<Method> getAnnotatedPropertyGetters(Class<?> objectClass, Class<? extends Annotation> annotation) {
        ArrayList<Method> ret = new ArrayList<Method>();
        for (Method getter : BeanUtils.getPropertyGetters(objectClass)) {
            if (annotation != null && getter.getAnnotation(annotation) == null) continue;
            ret.add(getter);
        }
        return ret;
    }

    public static void copyNotNullSNMPProperties(Object source, Object destination) {
        Class<?> sourceClass = source.getClass();
        for (Method method : BeanUtils.getPropertyGetters(sourceClass)) {
            if (method.getAnnotation(SNMPParameter.class) == null) continue;
            try {
                Object value = method.invoke(source, NO_PARAMS);
                if (value == null) continue;
                String property = BeanUtils.getPropertyNameFromGetter(method);
                Method setter = BeanUtils.getSetter(destination.getClass(), property);
                setter.invoke(destination, value);
            }
            catch (IllegalArgumentException e) {
                log.error((Object)e, (Throwable)e);
            }
            catch (IllegalAccessException e) {
                log.error((Object)e, (Throwable)e);
            }
            catch (InvocationTargetException e) {
                log.error((Object)e, (Throwable)e);
            }
        }
    }

    public static String uppercaseFirstChar(String s) {
        if (Character.isUpperCase(s.charAt(0))) {
            return s;
        }
        return Character.toUpperCase(s.charAt(0)) + s.substring(1);
    }
}

