/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.util;

import com.bwanms.gui.Internationalizer;
import com.bwanms.validation.WeakFloatStepRange;
import com.bwanms.validation.WeakRange;
import java.lang.annotation.Annotation;

public class AnnotationUtil {
    private static final Internationalizer i18n = Internationalizer.getInternationalizer("com.bwanms.validator");

    public static WeakRange createWeakRange(final long min, final long max) {
        return new WeakRange(){

            @Override
            public long min() {
                return min;
            }

            @Override
            public long max() {
                return max;
            }

            @Override
            public String message() {
                return i18n.translateString("weakRange", this.min(), this.max());
            }

            @Override
            public Class<? extends Annotation> annotationType() {
                return WeakRange.class;
            }
        };
    }

    public static WeakFloatStepRange createWeakFloatStepRange(final double min, final double max, final double step) {
        return new WeakFloatStepRange(){

            @Override
            public double min() {
                return min;
            }

            @Override
            public double max() {
                return max;
            }

            @Override
            public double step() {
                return step;
            }

            @Override
            public double[] acceptedValues() {
                return new double[0];
            }

            @Override
            public String message() {
                return i18n.translateString("weakFloatStepRange", this.min(), this.max(), this.step());
            }

            @Override
            public Class<? extends Annotation> annotationType() {
                return WeakFloatStepRange.class;
            }
        };
    }
}

