/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.ui.platform;

import org.apache.log4j.Logger;

public abstract class UIBackgroundJob {
    private static final Logger logger = Logger.getLogger(UIBackgroundJob.class);
    private boolean alive = false;
    private boolean scheduled = false;

    public abstract void run();

    public void schedule() {
        this.setScheduled(true);
        Thread t = new Thread(new Runnable(){

            public void run() {
                UIBackgroundJob.this.setAlive(true);
                try {
                    UIBackgroundJob.this.run();
                }
                catch (Throwable e) {
                    logger.error((Object)"Uncatched exception:", e);
                }
                UIBackgroundJob.this.setAlive(false);
            }
        }, this.getClass().getName() + ".schedule");
        t.start();
    }

    private synchronized void setScheduled(boolean scheduled) {
        this.scheduled = scheduled;
    }

    private synchronized void setAlive(boolean alive) {
        this.alive = alive;
        if (!alive) {
            this.scheduled = false;
        }
    }

    public synchronized boolean isAlive() {
        return this.alive;
    }

    public synchronized boolean isScheduled() {
        return this.scheduled;
    }
}

