/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.ui.components.defaultvalues;

import com.bwanms.ui.components.defaultvalues.Default;
import com.bwanms.util.BeanUtils;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import org.apache.log4j.Logger;

public class DefaultUtils {
    private static final Logger log = Logger.getLogger(DefaultUtils.class);

    public static void setDefaults(Object bean) {
        for (Method m : BeanUtils.getPropertyGetters(bean.getClass())) {
            Default def = m.getAnnotation(Default.class);
            if (null == def) continue;
            try {
                if (m.invoke(bean, new Object[0]) != null) continue;
                Constructor<?> constructor = m.getReturnType().getConstructor(String.class);
                Object newDefValue = constructor.newInstance(def.value());
                if (null == newDefValue) continue;
                BeanUtils.setPropertyValue(bean, BeanUtils.getPropertyNameFromGetter(m), newDefValue);
            }
            catch (Exception e) {
                log.error((Object)e, (Throwable)e);
            }
        }
    }

    public static String getDefaultValue(Class beanClass, String propertyName) {
        for (Method m : BeanUtils.getPropertyGetters(beanClass)) {
            if (!propertyName.equals(BeanUtils.getPropertyName(m.getName()))) continue;
            return m.getAnnotation(Default.class).value();
        }
        throw new NullPointerException("Bean " + beanClass + " doesn't have a property named " + propertyName);
    }
}

