/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.ui.components.closeandmaxtabbedpane;

import com.bwanms.ui.components.closeandmaxtabbedpane.CloseListener;
import com.bwanms.ui.components.closeandmaxtabbedpane.CloseTabPaneEnhancedUI;
import com.bwanms.ui.components.closeandmaxtabbedpane.CloseTabPaneUI;
import com.bwanms.ui.components.closeandmaxtabbedpane.DoubleClickListener;
import com.bwanms.ui.components.closeandmaxtabbedpane.MaxListener;
import com.bwanms.ui.components.closeandmaxtabbedpane.PopupOutsideListener;
import com.bwanms.util.FrameUtil;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Window;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.util.EventListener;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.plaf.TabbedPaneUI;

public class CloseAndMaxTabbedPane
extends JTabbedPane {
    private int overTabIndex = -1;
    private Image backgroundImage;
    private CloseTabPaneUI paneUI;

    public CloseAndMaxTabbedPane(boolean enhancedUI) {
        super.setTabLayoutPolicy(1);
        this.paneUI = enhancedUI ? new CloseTabPaneEnhancedUI() : new CloseTabPaneUI();
        super.setUI(this.paneUI);
    }

    public int getOverTabIndex() {
        return this.overTabIndex;
    }

    public boolean isCloseEnabled() {
        return this.paneUI.isCloseEnabled();
    }

    public boolean isMaxEnabled() {
        return this.paneUI.isMaxEnabled();
    }

    public void setTabLayoutPolicy(int tabLayoutPolicy) {
    }

    public void setTabPlacement(int tabPlacement) {
    }

    public void setUI(TabbedPaneUI ui) {
    }

    public void setCloseIcon(boolean b) {
        this.paneUI.setCloseIcon(b);
    }

    public void setMaxIcon(boolean b) {
        this.paneUI.setMaxIcon(b);
    }

    public void detachTab(int index) {
        if (index < 0 || index >= this.getTabCount()) {
            return;
        }
        final JFrame frame = FrameUtil.createFrame();
        Window parentWindow = SwingUtilities.windowForComponent(this);
        final int tabIndex = index;
        final JComponent c = (JComponent)this.getComponentAt(tabIndex);
        final Icon icon = this.getIconAt(tabIndex);
        final String title = this.getTitleAt(tabIndex);
        final String toolTip = this.getToolTipTextAt(tabIndex);
        final Border border = c.getBorder();
        this.removeTabAt(index);
        c.setPreferredSize(c.getSize());
        frame.setTitle(title);
        frame.getContentPane().add(c);
        frame.setLocation(parentWindow.getLocation());
        frame.pack();
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent event) {
                frame.dispose();
                CloseAndMaxTabbedPane.this.insertTab(title, icon, c, toolTip, Math.min(tabIndex, CloseAndMaxTabbedPane.this.getTabCount()));
                c.setBorder(border);
                CloseAndMaxTabbedPane.this.setSelectedComponent(c);
            }
        });
        WindowFocusListener windowFocusListener = new WindowFocusListener(){
            long start;
            long end;

            public void windowGainedFocus(WindowEvent e) {
                this.start = System.currentTimeMillis();
            }

            public void windowLostFocus(WindowEvent e) {
                this.end = System.currentTimeMillis();
                long elapsed = this.end - this.start;
                if (elapsed < 100L) {
                    frame.toFront();
                }
                frame.removeWindowFocusListener(this);
            }
        };
        frame.addWindowFocusListener(windowFocusListener);
        frame.show();
        frame.toFront();
    }

    public synchronized void addCloseListener(CloseListener l) {
        this.listenerList.add(CloseListener.class, l);
    }

    public synchronized void addMaxListener(MaxListener l) {
        this.listenerList.add(MaxListener.class, l);
    }

    public synchronized void addDoubleClickListener(DoubleClickListener l) {
        this.listenerList.add(DoubleClickListener.class, l);
    }

    public synchronized void addPopupOutsideListener(PopupOutsideListener l) {
        this.listenerList.add(PopupOutsideListener.class, l);
    }

    public synchronized void removeCloseListener(CloseListener l) {
        this.listenerList.remove(CloseListener.class, l);
    }

    public synchronized void removeMaxListener(MaxListener l) {
        this.listenerList.remove(MaxListener.class, l);
    }

    public synchronized void removeDoubleClickListener(DoubleClickListener l) {
        this.listenerList.remove(DoubleClickListener.class, l);
    }

    public synchronized void removePopupOutsideListener(PopupOutsideListener l) {
        this.listenerList.remove(PopupOutsideListener.class, l);
    }

    public void fireCloseTabEvent(MouseEvent e, int overTabIndex) {
        this.overTabIndex = overTabIndex;
        EventListener[] closeListeners = this.getListeners(CloseListener.class);
        for (int i = 0; i < closeListeners.length; ++i) {
            ((CloseListener)closeListeners[i]).closeOperation(e);
        }
    }

    public void fireMaxTabEvent(MouseEvent e, int overTabIndex) {
        this.overTabIndex = overTabIndex;
        EventListener[] maxListeners = this.getListeners(MaxListener.class);
        for (int i = 0; i < maxListeners.length; ++i) {
            ((MaxListener)maxListeners[i]).maxOperation(e);
        }
    }

    public void fireDoubleClickTabEvent(MouseEvent e, int overTabIndex) {
        this.overTabIndex = overTabIndex;
        EventListener[] dClickListeners = this.getListeners(DoubleClickListener.class);
        for (int i = 0; i < dClickListeners.length; ++i) {
            ((DoubleClickListener)dClickListeners[i]).doubleClickOperation(e);
        }
    }

    public void firePopupOutsideTabEvent(MouseEvent e) {
        this.overTabIndex = -1;
        EventListener[] popupListeners = this.getListeners(PopupOutsideListener.class);
        for (int i = 0; i < popupListeners.length; ++i) {
            ((PopupOutsideListener)popupListeners[i]).popupOutsideOperation(e);
        }
    }

    public void setBackgroundImage(Image backgroundImage) {
        this.backgroundImage = backgroundImage;
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.backgroundImage != null) {
            g.drawImage(this.backgroundImage, 1, 25, this);
        }
    }
}

