/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.ui.components;

import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.JTextArea;

public class TextAreaMultiThreading {
    private JTextArea textArea;
    private Hashtable<String, int[]> threadMap;
    private boolean autoscroll = false;

    public TextAreaMultiThreading(JTextArea text) {
        this.textArea = text;
        this.threadMap = new Hashtable();
    }

    public void setAutoscroll(boolean scroll) {
        this.autoscroll = scroll;
    }

    public boolean getAutoscroll() {
        return this.autoscroll;
    }

    public synchronized void insert(String id, String str) {
        int[] offset = this.threadMap.get(id);
        if (offset == null) {
            this.textArea.append(str);
            offset = new int[]{this.textArea.getText().length()};
            this.threadMap.put(id, offset);
        } else {
            this.textArea.insert(str, offset[0]);
            int size = str.length();
            this.updateOffsets(offset[0], size);
        }
        this.autoscroll(offset[0]);
    }

    public synchronized void insertSeparator(String id, String str) {
        int[] offset = this.threadMap.get(id);
        if (offset == null) {
            this.textArea.append(str);
            offset = new int[]{this.textArea.getText().length() - str.length()};
            this.threadMap.put(id, offset);
        } else {
            this.textArea.insert(str, offset[0]);
            int size = str.length();
            this.updateOffsets(offset[0], size);
            offset[0] = offset[0] - size;
        }
        this.autoscroll(offset[0]);
    }

    private void updateOffsets(int pos, int size) {
        Enumeration<int[]> e = this.threadMap.elements();
        while (e.hasMoreElements()) {
            int[] val = e.nextElement();
            if (val[0] < pos) continue;
            val[0] = val[0] + size;
        }
    }

    public synchronized void append(String str) {
        this.textArea.append(str);
        this.autoscroll(this.textArea.getText().length());
    }

    public synchronized void setText(String str) {
        this.threadMap.clear();
        this.textArea.setText(str);
        this.autoscroll(str.length());
    }

    public synchronized void clear() {
        this.threadMap.clear();
        this.textArea.setText("");
    }

    private void autoscroll(int pos) {
        if (this.autoscroll) {
            this.textArea.setCaretPosition(pos);
        }
    }
}

